/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.codejson;

import com.jfireframework.codejson.Json;
import com.jfireframework.codejson.JsonArray;
import java.util.HashMap;

public class JsonObject
extends HashMap<String, Object>
implements Json {
    private static final long serialVersionUID = 1L;
    private Json parentNode;

    public Object get(String key) {
        return super.get(key);
    }

    public JsonObject getJsonObject(String key) {
        return (JsonObject)this.get(key);
    }

    public JsonArray getJsonArray(String key) {
        return (JsonArray)this.get(key);
    }

    public boolean contains(String key) {
        return this.containsKey(key);
    }

    public String getWString(String key) {
        return (String)this.get(key);
    }

    public Long getWLong(String key) {
        return (Long)this.get(key);
    }

    public Integer getWInteger(String key) {
        Long value = (Long)this.get(key);
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public Double getWDouble(String key) {
        return (Double)this.get(key);
    }

    public Boolean getWBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Float getWFloat(String key) {
        Double value = (Double)this.get(key);
        if (value != null) {
            return Float.valueOf(value.floatValue());
        }
        return null;
    }

    public Byte getWByte(String key) {
        Long value = (Long)this.get(key);
        if (value == null) {
            return null;
        }
        return value.byteValue();
    }

    public Short getWShort(String key) {
        Long value = (Long)this.get(key);
        if (value == null) {
            return null;
        }
        return value.shortValue();
    }

    public Character getWCharacter(String key) {
        String value = (String)this.get(key);
        if (value != null) {
            return Character.valueOf(value.charAt(0));
        }
        return null;
    }

    public int getInt(String key) {
        return ((Long)this.get(key)).intValue();
    }

    public float getFloat(String key) {
        return ((Double)this.get(key)).floatValue();
    }

    public byte getByte(String key) {
        return ((Long)this.get(key)).byteValue();
    }

    public char getChar(String key) {
        return ((String)this.get(key)).charAt(0);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public long getLong(String key) {
        return (Long)this.get(key);
    }

    public short getShort(String key) {
        return ((Long)this.get(key)).shortValue();
    }

    @Override
    public void setParentNode(Json json) {
        this.parentNode = json;
    }

    @Override
    public Json getParentNode() {
        return this.parentNode;
    }

    @Override
    public boolean hasParentNode() {
        return this.parentNode != null;
    }
}

