/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.codejson;

import com.jfireframework.baseutil.collection.StringCache;
import com.jfireframework.baseutil.verify.Verify;
import com.jfireframework.codejson.Json;
import com.jfireframework.codejson.JsonArray;
import com.jfireframework.codejson.JsonObject;
import com.jfireframework.codejson.function.ReaderContext;
import com.jfireframework.codejson.function.WriterContext;
import java.lang.reflect.Type;

public class JsonTool {
    private static ThreadLocal<StringCache> cacheLocal = new ThreadLocal<StringCache>(){

        @Override
        protected StringCache initialValue() {
            return new StringCache(2048);
        }
    };
    private static final int NONE = 0;
    private static final int JSONOBJECT = 1;
    private static final int JSONARRAY = 2;

    public static String write(Object value) {
        StringCache cache = cacheLocal.get();
        cache.clear();
        WriterContext.write(value, cache);
        return cache.toString();
    }

    public static <T> T read(Type entityClass, String str) {
        return (T)ReaderContext.getReader(entityClass).read(entityClass, JsonTool.fromString(str));
    }

    public static <T> T read(Type entityClass, Json json) {
        return (T)ReaderContext.getReader(entityClass).read(entityClass, json);
    }

    public static Json fromString(String str) {
        JsonObject lastJsonObject = null;
        JsonArray lastJsonArray = null;
        int nodeState = 0;
        int flag = 0;
        int index = 0;
        int length = str.length();
        char[] array = new char[str.length()];
        str.getChars(0, length, array, 0);
        boolean strStartRead = false;
        String jsonKey = null;
        block20: while (index < length) {
            char c = array[index];
            switch (c) {
                case '/': {
                    if (array[index + 1] != '*') break;
                    int end = str.indexOf("*/", index);
                    if (end == -1) {
                        throw new RuntimeException("json\u5b57\u7b26\u4e32\u5b58\u5728\u95ee\u9898");
                    }
                    index = end + 2;
                    flag = flag == 0 ? 0 : index;
                    continue block20;
                }
                case '{': {
                    JsonObject tmp = new JsonObject();
                    switch (nodeState) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            lastJsonObject.put(jsonKey, tmp);
                            tmp.setParentNode(lastJsonObject);
                            jsonKey = null;
                            flag = 0;
                            break;
                        }
                        case 2: {
                            lastJsonArray.add(tmp);
                            tmp.setParentNode(lastJsonArray);
                        }
                    }
                    nodeState = 1;
                    lastJsonObject = tmp;
                    break;
                }
                case '}': {
                    if (flag != 0) {
                        Object value = JsonTool.getNotStrValue(flag, index - 1, array);
                        if (value != null) {
                            lastJsonObject.put(jsonKey, value);
                        }
                        jsonKey = null;
                        flag = 0;
                    }
                    if (lastJsonObject.hasParentNode()) {
                        Json parentNode = lastJsonObject.getParentNode();
                        if (parentNode instanceof JsonObject) {
                            lastJsonObject = (JsonObject)parentNode;
                            nodeState = 1;
                            break;
                        }
                        lastJsonArray = (JsonArray)parentNode;
                        nodeState = 2;
                        break;
                    }
                    return lastJsonObject;
                }
                case '[': {
                    JsonArray tmp1 = new JsonArray();
                    switch (nodeState) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            lastJsonObject.put(jsonKey, tmp1);
                            tmp1.setParentNode(lastJsonObject);
                            jsonKey = null;
                            break;
                        }
                        case 2: {
                            lastJsonArray.add(tmp1);
                            tmp1.setParentNode(lastJsonArray);
                        }
                    }
                    nodeState = 2;
                    lastJsonArray = tmp1;
                    flag = index + 1;
                    break;
                }
                case ']': {
                    if (flag != 0 && flag != index) {
                        Object value = JsonTool.getNotStrValue(flag, index - 1, array);
                        if (value != null) {
                            lastJsonArray.add(value);
                        }
                        flag = 0;
                    }
                    if (lastJsonArray.hasParentNode()) {
                        Json parentNode1 = lastJsonArray.getParentNode();
                        if (parentNode1 instanceof JsonObject) {
                            lastJsonObject = (JsonObject)parentNode1;
                            nodeState = 1;
                        } else {
                            lastJsonArray = (JsonArray)parentNode1;
                            nodeState = 2;
                        }
                        flag = 0;
                        break;
                    }
                    return lastJsonArray;
                }
                case '\"': {
                    int end = str.indexOf(34, ++index);
                    Verify.True((end != -1 ? 1 : 0) != 0, (String)"json\u5b57\u7b26\u4e32\u5b58\u5728\u5f02\u5e38", (Object[])new Object[0]);
                    if (nodeState == 1) {
                        if (jsonKey == null) {
                            jsonKey = new String(array, index, end - index);
                        } else {
                            lastJsonObject.put(jsonKey, new String(array, index, end - index));
                            jsonKey = null;
                        }
                    } else if (nodeState == 2) {
                        lastJsonArray.add(new String(array, index, end - index));
                    } else {
                        throw new RuntimeException("\u9519\u8bef\u7684json\u683c\u5f0f");
                    }
                    flag = 0;
                    strStartRead = false;
                    index = end + 1;
                    continue block20;
                }
                case ':': {
                    if (strStartRead || flag != 0) break;
                    flag = index + 1;
                    break;
                }
                case ',': {
                    if (strStartRead || flag == 0) break;
                    Object value = JsonTool.getNotStrValue(flag, index - 1, array);
                    if (nodeState == 1) {
                        if (value != null) {
                            lastJsonObject.put(jsonKey, value);
                        }
                        jsonKey = null;
                        flag = 0;
                        break;
                    }
                    if (nodeState == 2) {
                        if (value != null) {
                            lastJsonArray.add(value);
                        }
                        flag = index + 1;
                        break;
                    }
                    throw new RuntimeException("\u9519\u8bef\u7684json\u683c\u5f0f");
                }
            }
            ++index;
        }
        throw new RuntimeException("json\u5b57\u7b26\u4e32\u5b58\u5728\u9519\u8bef");
    }

    private static Object getNotStrValue(int flag, int index, char[] value) {
        block12: while (true) {
            switch (value[flag]) {
                case ' ': {
                    ++flag;
                    continue block12;
                }
                case '\t': {
                    ++flag;
                    continue block12;
                }
                case '\r': {
                    ++flag;
                    continue block12;
                }
                case '\n': {
                    ++flag;
                    continue block12;
                }
            }
            break;
        }
        block13: while (true) {
            switch (value[index]) {
                case ' ': {
                    --index;
                    continue block13;
                }
                case '\t': {
                    --index;
                    continue block13;
                }
                case '\r': {
                    --index;
                    continue block13;
                }
                case '\n': {
                    --index;
                    continue block13;
                }
            }
            break;
        }
        String tmp = new String(value, flag, index - flag + 1);
        if (tmp.equals("true")) {
            return Boolean.TRUE;
        }
        if (tmp.equals("false")) {
            return Boolean.FALSE;
        }
        if (tmp.equals("null")) {
            return null;
        }
        if (tmp.contains(".")) {
            return Double.valueOf(tmp);
        }
        if (tmp.equals("{")) {
            return null;
        }
        return Long.valueOf(tmp);
    }

    public static String toString(Object value) {
        return JsonTool.write(value);
    }
}

