/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.codejson.function;

import com.jfireframework.codejson.JsonTool;
import com.jfireframework.codejson.function.JsonReader;
import com.jfireframework.codejson.function.ReaderContext;
import com.jfireframework.codejson.function.Strategy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReadStrategy
implements Strategy {
    private Map<Type, JsonReader> typeStrategy = new HashMap<Type, JsonReader>();
    private Map<String, JsonReader> fieldStrategy = new HashMap<String, JsonReader>();
    private Set<String> ignoreFields = new HashSet<String>();
    private Map<String, String> renameFields = new HashMap<String, String>();
    private JsonReader reader;
    private boolean readEnumName = true;

    public boolean isReadEnumName() {
        return this.readEnumName;
    }

    public void setReadEnumName(boolean readEnumName) {
        this.readEnumName = readEnumName;
    }

    @Override
    public String getRename(String fieldName) {
        return this.renameFields.get(fieldName);
    }

    @Override
    public boolean containsRename(String fieldName) {
        return this.renameFields.containsKey(fieldName);
    }

    public boolean containsStrategyType(Class<?> type) {
        return this.typeStrategy.containsKey(type);
    }

    public JsonReader getReader(Type type) {
        this.reader = this.typeStrategy.get(type);
        if (this.reader == null) {
            this.reader = ReaderContext.getReader(type, this);
            this.typeStrategy.put(type, this.reader);
            return this.reader;
        }
        return this.reader;
    }

    public JsonReader getReaderByField(String fieldName) {
        return this.fieldStrategy.get(fieldName);
    }

    public void addTypeStrategy(Class<?> ckass, JsonReader jsonReader) {
        this.typeStrategy.put(ckass, jsonReader);
    }

    public boolean containsStrategyField(String fieldName) {
        return this.fieldStrategy.containsKey(fieldName);
    }

    public void addFieldStrategy(String fieldName, JsonReader reader) {
        this.fieldStrategy.put(fieldName, reader);
    }

    public void addIgnoreField(String fieldName) {
        this.ignoreFields.add(fieldName);
    }

    public boolean ignore(String fieldName) {
        return this.ignoreFields.contains(fieldName);
    }

    public void addRenameField(String originName, String rename) {
        this.renameFields.put(originName, rename);
    }

    public <T> T read(Type entityClass, String str) {
        return (T)this.getReader(entityClass).read(entityClass, JsonTool.fromString(str));
    }
}

