/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.codejson.function;

import com.jfireframework.baseutil.collection.StringCache;
import com.jfireframework.codejson.function.JsonWriter;
import com.jfireframework.codejson.function.Strategy;
import com.jfireframework.codejson.function.WriterContext;
import com.jfireframework.codejson.function.impl.write.array.BooleanArrayWriter;
import com.jfireframework.codejson.function.impl.write.array.ByteArrayWriter;
import com.jfireframework.codejson.function.impl.write.array.CharArrayWriter;
import com.jfireframework.codejson.function.impl.write.array.DoubleArrayWriter;
import com.jfireframework.codejson.function.impl.write.array.FloatArrayWriter;
import com.jfireframework.codejson.function.impl.write.array.IntArrayWriter;
import com.jfireframework.codejson.function.impl.write.array.LongArrayWriter;
import com.jfireframework.codejson.function.impl.write.array.ShortArrayWriter;
import com.jfireframework.codejson.function.impl.write.array.StringArrayWriter;
import com.jfireframework.codejson.function.impl.write.extra.ArrayListWriter;
import com.jfireframework.codejson.function.impl.write.extra.DateWriter;
import com.jfireframework.codejson.function.impl.write.wrapper.BooleanWriter;
import com.jfireframework.codejson.function.impl.write.wrapper.ByteWriter;
import com.jfireframework.codejson.function.impl.write.wrapper.CharacterWriter;
import com.jfireframework.codejson.function.impl.write.wrapper.DoubleWriter;
import com.jfireframework.codejson.function.impl.write.wrapper.FloatWriter;
import com.jfireframework.codejson.function.impl.write.wrapper.IntegerWriter;
import com.jfireframework.codejson.function.impl.write.wrapper.LongWriter;
import com.jfireframework.codejson.function.impl.write.wrapper.ShortWriter;
import com.jfireframework.codejson.function.impl.write.wrapper.StringWriter;
import com.jfireframework.codejson.tracker.Tracker;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WriteStrategy
implements Strategy {
    private Map<Class<?>, JsonWriter> trackerType = new HashMap();
    private Map<Class<?>, JsonWriter> typeStrategy = new HashMap();
    private Map<String, JsonWriter> fieldStrategy = new HashMap<String, JsonWriter>();
    private Set<String> ignoreFields = new HashSet<String>();
    private Map<String, String> renameFields = new HashMap<String, String>();
    private JsonWriter writer;
    private boolean useTracker = false;
    private ThreadLocal<StringCache> cacheLocal = new ThreadLocal<StringCache>(){

        @Override
        protected StringCache initialValue() {
            return new StringCache();
        }
    };
    private ThreadLocal<Tracker> trackerLocal = new ThreadLocal<Tracker>(){

        @Override
        protected Tracker initialValue() {
            return new Tracker();
        }
    };
    private boolean writeEnumName = true;

    public WriteStrategy() {
        this.typeStrategy.put(String.class, new StringWriter());
        this.typeStrategy.put(Double.class, new DoubleWriter());
        this.typeStrategy.put(Float.class, new FloatWriter());
        this.typeStrategy.put(Integer.class, new IntegerWriter());
        this.typeStrategy.put(Long.class, new LongWriter());
        this.typeStrategy.put(Short.class, new ShortWriter());
        this.typeStrategy.put(Boolean.class, new BooleanWriter());
        this.typeStrategy.put(Byte.class, new ByteWriter());
        this.typeStrategy.put(Character.class, new CharacterWriter());
        this.typeStrategy.put(int[].class, new IntArrayWriter());
        this.typeStrategy.put(boolean[].class, new BooleanArrayWriter());
        this.typeStrategy.put(long[].class, new LongArrayWriter());
        this.typeStrategy.put(short[].class, new ShortArrayWriter());
        this.typeStrategy.put(byte[].class, new ByteArrayWriter());
        this.typeStrategy.put(float[].class, new FloatArrayWriter());
        this.typeStrategy.put(double[].class, new DoubleArrayWriter());
        this.typeStrategy.put(char[].class, new CharArrayWriter());
        this.typeStrategy.put(String[].class, new StringArrayWriter());
        this.typeStrategy.put(ArrayList.class, new ArrayListWriter());
        this.typeStrategy.put(java.util.Date.class, new DateWriter());
        this.typeStrategy.put(Date.class, new DateWriter());
    }

    public boolean isWriteEnumName() {
        return this.writeEnumName;
    }

    public void setWriteEnumName(boolean writeEnumName) {
        this.writeEnumName = writeEnumName;
    }

    public boolean isUseTracker() {
        return this.useTracker;
    }

    public void setUseTracker(boolean useTracker) {
        this.useTracker = useTracker;
    }

    public boolean containsStrategyType(Class<?> type) {
        return this.typeStrategy.containsKey(type);
    }

    public JsonWriter getWriter(Class<?> type) {
        this.writer = this.typeStrategy.get(type);
        if (this.writer == null) {
            this.writer = WriterContext.getWriter(type, this);
            this.typeStrategy.put(type, this.writer);
            return this.writer;
        }
        return this.writer;
    }

    public void addTypeStrategy(Class<?> ckass, JsonWriter jsonWriter) {
        this.typeStrategy.put(ckass, jsonWriter);
    }

    public void addTrackerType(Class<?> ckass, JsonWriter jsonWriter) {
        this.trackerType.put(ckass, jsonWriter);
    }

    public boolean containsTrackerType(Class<?> ckass) {
        return this.trackerType.containsKey(ckass);
    }

    public JsonWriter getTrackerType(Class<?> ckass) {
        return this.trackerType.get(ckass);
    }

    public boolean containsStrategyField(String fieldName) {
        return this.fieldStrategy.containsKey(fieldName);
    }

    public JsonWriter getWriterByField(String fieldName) {
        return this.fieldStrategy.get(fieldName);
    }

    public void addFieldStrategy(String fieldName, JsonWriter writer) {
        this.fieldStrategy.put(fieldName, writer);
    }

    public void addIgnoreField(String fieldName) {
        this.ignoreFields.add(fieldName);
    }

    public boolean ignore(String fieldName) {
        return this.ignoreFields.contains(fieldName);
    }

    public void addRenameField(String originName, String rename) {
        this.renameFields.put(originName, rename);
    }

    @Override
    public String getRename(String fieldName) {
        return this.renameFields.get(fieldName);
    }

    @Override
    public boolean containsRename(String fieldName) {
        return this.renameFields.containsKey(fieldName);
    }

    public String write(Object entity) {
        StringCache cache = this.cacheLocal.get();
        cache.clear();
        if (this.useTracker) {
            Tracker tracker = this.trackerLocal.get();
            tracker.clear();
            tracker.put(entity, "$", false);
            this.getWriter(entity.getClass()).write(entity, cache, null, tracker);
        } else {
            this.getWriter(entity.getClass()).write(entity, cache, null, null);
        }
        return cache.toString();
    }
}

