/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.codejson.function.impl.write;

import com.jfireframework.baseutil.collection.StringCache;
import com.jfireframework.codejson.function.JsonWriter;
import com.jfireframework.codejson.function.WriteStrategy;
import com.jfireframework.codejson.function.impl.write.WriterAdapter;
import com.jfireframework.codejson.function.impl.write.wrapper.StringWriter;
import com.jfireframework.codejson.tracker.Tracker;
import java.util.Map;
import java.util.Set;

public class StrategyMapWriter
extends WriterAdapter {
    private WriteStrategy strategy;
    private JsonWriter stringWriter;

    public StrategyMapWriter(WriteStrategy strategy) {
        this.strategy = strategy;
        this.stringWriter = strategy.getWriter(String.class);
        if (this.stringWriter instanceof StringWriter) {
            this.stringWriter = null;
        }
    }

    @Override
    public void write(Object field, StringCache cache, Object entity, Tracker tracker) {
        cache.append('{');
        Set set = ((Map)field).entrySet();
        for (Map.Entry each : set) {
            if (each.getKey() == null || each.getValue() == null) continue;
            if (each.getKey() instanceof String) {
                if (this.stringWriter == null) {
                    cache.append('\"').append((String)each.getKey()).append("\":");
                } else {
                    this.stringWriter.write(each.getKey(), cache, entity, tracker);
                    cache.append(':');
                }
            } else {
                cache.append('\"');
                this.strategy.getWriter(each.getKey().getClass()).write(each.getKey(), cache, entity, tracker);
                cache.append("\":");
            }
            if (each.getValue() instanceof String) {
                if (this.stringWriter == null) {
                    cache.append('\"').append((String)each.getValue()).append('\"');
                } else {
                    this.stringWriter.write(each.getValue(), cache, entity, tracker);
                }
            } else {
                this.strategy.getWriter(each.getValue().getClass()).write(each.getValue(), cache, entity, tracker);
            }
            cache.append(',');
        }
        if (cache.isCommaLast()) {
            cache.deleteLast();
        }
        cache.append('}');
    }
}

