/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink;

import com.jianggujin.modulelink.util.JAssert;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class JModuleConfig
implements Comparable<JModuleConfig> {
    private final String name;
    private String desc;
    private final String version;
    private Set<URL> moduleUrls = new HashSet<URL>();
    private Set<String> actions = new HashSet<String>();
    private Set<String> exclusionActions = new HashSet<String>();
    private Set<String> scanPackages = new HashSet<String>();
    private boolean active;

    public JModuleConfig(String name, String version) {
        JAssert.checkNotNull(name, "name must not be null");
        JAssert.checkNotNull(version, "version must not be null");
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public JModuleConfig withDesc(String desc) {
        this.setDesc(desc);
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<URL> getModuleUrls() {
        return this.moduleUrls;
    }

    public void setModuleUrls(Set<URL> moduleUrls) {
        JAssert.checkNotNull(moduleUrls, "moduleUrls must not be null");
        this.moduleUrls = moduleUrls;
    }

    public JModuleConfig withModuleUrls(Set<URL> moduleUrls) {
        this.setModuleUrls(moduleUrls);
        return this;
    }

    public JModuleConfig addModuleUrls(Collection<URL> moduleUrls) {
        if (moduleUrls != null) {
            this.moduleUrls.addAll(moduleUrls);
        }
        return this;
    }

    public JModuleConfig addModuleUrl(URL moduleUrl) {
        JAssert.checkNotNull(moduleUrl, "moduleUrl must not be null");
        this.moduleUrls.add(moduleUrl);
        return this;
    }

    public JModuleConfig removeModuleUrl(URL moduleUrl) {
        this.moduleUrls.remove(moduleUrl);
        return this;
    }

    public Set<String> getActions() {
        return this.actions;
    }

    public void setActions(Set<String> actions) {
        JAssert.checkNotNull(actions, "actions must not be null");
        this.actions = actions;
    }

    public JModuleConfig withActions(Set<String> actions) {
        this.setActions(actions);
        return this;
    }

    public JModuleConfig addActions(Collection<String> actions) {
        if (actions != null) {
            this.actions.addAll(actions);
        }
        return this;
    }

    public JModuleConfig addAction(String action) {
        JAssert.checkNotNull(action, "action must not be null");
        this.actions.add(action);
        return this;
    }

    public JModuleConfig removeAction(String action) {
        this.actions.remove(action);
        return this;
    }

    public Set<String> getExclusionActions() {
        return this.exclusionActions;
    }

    public void setExclusionActions(Set<String> exclusionActions) {
        JAssert.checkNotNull(exclusionActions, "exclusionActions must not be null");
        this.exclusionActions = exclusionActions;
    }

    public JModuleConfig withExclusionActions(Set<String> exclusionActions) {
        this.setExclusionActions(exclusionActions);
        return this;
    }

    public JModuleConfig addExclusionActions(Collection<String> exclusionActions) {
        if (exclusionActions != null) {
            this.exclusionActions.addAll(exclusionActions);
        }
        return this;
    }

    public JModuleConfig addExclusionAction(String exclusionAction) {
        JAssert.checkNotNull(exclusionAction, "exclusionAction must not be null");
        this.exclusionActions.add(exclusionAction);
        return this;
    }

    public JModuleConfig removeExclusionAction(String exclusionAction) {
        this.exclusionActions.remove(exclusionAction);
        return this;
    }

    public Set<String> getScanPackages() {
        return this.scanPackages;
    }

    public void setScanPackages(Set<String> scanPackages) {
        JAssert.checkNotNull(scanPackages, "scanPackages must not be null");
        this.scanPackages = scanPackages;
    }

    public JModuleConfig withScanPackages(Set<String> scanPackages) {
        this.setScanPackages(scanPackages);
        return this;
    }

    public JModuleConfig addScanPackages(Collection<String> scanPackages) {
        if (scanPackages != null) {
            this.scanPackages.addAll(scanPackages);
        }
        return this;
    }

    public JModuleConfig addScanPackage(String packageName) {
        JAssert.checkNotNull(packageName, "packageName must not be null");
        this.scanPackages.add(packageName);
        return this;
    }

    public JModuleConfig removeScanPackage(String packageName) {
        this.scanPackages.remove(packageName);
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public JModuleConfig withActive(boolean active) {
        this.setActive(active);
        return this;
    }

    @Override
    public int compareTo(JModuleConfig other) {
        String name = other.name;
        String version = other.version;
        int value = this.name.compareTo(name);
        if (value == 0) {
            return this.version.compareTo(version);
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JModuleConfig other = (JModuleConfig)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "JModuleConfig [name=" + this.name + ", desc=" + this.desc + ", version=" + this.version + ", moduleUrls=" + this.moduleUrls + ", actions=" + this.actions + ", exclusionActions=" + this.exclusionActions + ", scanPackages=" + this.scanPackages + ", active=" + this.active + "]";
    }
}

