/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl;

import com.jianggujin.modulelink.JAction;
import com.jianggujin.modulelink.JModule;
import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.JModuleClassLoader;
import com.jianggujin.modulelink.util.JModuleUtils;
import java.beans.Introspector;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JAbstractModule
implements JModule {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JAbstractModule.class);
    protected final JModuleConfig moduleConfig;
    protected JAction defaultAction;
    protected Map<String, JAction> actions;

    public JAbstractModule(JModuleConfig moduleConfig) {
        JAssert.checkNotNull(moduleConfig, "moduleConfig must not be null");
        this.moduleConfig = moduleConfig;
        this.actions = new ConcurrentHashMap<String, JAction>();
    }

    @Override
    public Set<String> getActionNames() {
        return this.actions.keySet();
    }

    @Override
    public JAction findAction(String name) {
        return this.actions.get(name);
    }

    @Override
    public JAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public Object doAction(String actionName, Object in) {
        JAssert.checkNotNull(actionName, "actionName must not be null");
        return JModuleUtils.doActionWithinModuleClassLoader(this.actions.get(actionName), in);
    }

    @Override
    public boolean hasAction(String actionName) {
        return this.actions.containsKey(actionName);
    }

    @Override
    public Object doDefaultAction(Object in) {
        return JModuleUtils.doActionWithinModuleClassLoader(this.defaultAction, in);
    }

    @Override
    public boolean hasDefaultAction() {
        return this.defaultAction != null;
    }

    @Override
    public void destroy() {
        this.actions.clear();
        this.defaultAction = null;
        Introspector.flushCaches();
        ClassLoader classLoader = this.getModuleClassLoader();
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        ResourceBundle.clearCache(classLoader);
        if (classLoader instanceof JModuleClassLoader) {
            try {
                ((JModuleClassLoader)classLoader).close();
            }
            catch (IOException e) {
                logger.error("close classLoader error.", e);
            }
        }
    }

    @Override
    public JModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }
}

