/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl;

import com.jianggujin.modulelink.JModule;
import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.JModuleLinkException;
import com.jianggujin.modulelink.JModuleManager;
import com.jianggujin.modulelink.JModuleNotFoundException;
import com.jianggujin.modulelink.impl.JRuntimeModule;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.JModuleClassLoader;
import com.jianggujin.modulelink.util.JModuleUtils;
import java.beans.Introspector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JAbstractModuleManager
implements JModuleManager {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JAbstractModuleManager.class);
    private final ConcurrentHashMap<String, Object> parallelLockMap;
    private final Map<String, JRuntimeModule> modules = new ConcurrentHashMap<String, JRuntimeModule>();

    public JAbstractModuleManager() {
        this.parallelLockMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JModule load(JModuleConfig moduleConfig) {
        JAssert.checkNotNull(moduleConfig, "moduleConfig must not be null");
        if (logger.isInfoEnabled()) {
            logger.info("Loading module: " + moduleConfig);
        }
        String moduleName = moduleConfig.getName();
        String version = moduleConfig.getVersion();
        JModule module = null;
        Object object = this.getLock(moduleName);
        synchronized (object) {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            JModuleClassLoader moduleClassLoader = this.createModuleClassLoader(moduleConfig);
            JRuntimeModule runtimeModule = this.modules.get(moduleName);
            JAssert.checkState(runtimeModule == null || !runtimeModule.hasVersion(version), "module name already exists");
            if (runtimeModule == null) {
                runtimeModule = new JRuntimeModule(moduleName);
                this.modules.put(moduleName, runtimeModule);
            }
            try {
                Thread.currentThread().setContextClassLoader(moduleClassLoader);
                module = this.load(moduleConfig, moduleClassLoader);
                if (module == null) {
                    throw new NullPointerException("load module is null.");
                }
                runtimeModule.add(module);
            }
            catch (Throwable e) {
                this.loadModuleError(moduleClassLoader);
                throw new JModuleLinkException("load module error.", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("loading module complete\uff1a" + moduleConfig);
        }
        return module;
    }

    protected JModuleClassLoader createModuleClassLoader(JModuleConfig moduleConfig) {
        return new JModuleClassLoader(moduleConfig.getModuleUrls(), Thread.currentThread().getContextClassLoader());
    }

    protected abstract JModule load(JModuleConfig var1, ClassLoader var2) throws Exception;

    protected void loadModuleError(ClassLoader moduleClassLoader) {
        Introspector.flushCaches();
        ResourceBundle.clearCache(moduleClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload(String name) {
        JAssert.checkNotNull(name, "module name must not be null");
        Object object = this.getLock(name);
        synchronized (object) {
            JRuntimeModule runtimeModule = this.modules.remove(name);
            if (runtimeModule == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name);
            }
            Collection<JModule> list = null;
            list = runtimeModule.clear();
            if (list != null) {
                for (JModule module : list) {
                    JModuleUtils.destroyQuietly(module);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload(String name, String version) {
        JAssert.checkNotNull(name, "module name must not be null");
        JAssert.checkNotNull(version, "module version must not be null");
        Object object = this.getLock(name);
        synchronized (object) {
            JRuntimeModule runtimeModule = this.modules.get(name);
            if (runtimeModule == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name);
            }
            JModule module = runtimeModule.remove(version);
            if (module == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name + " and version:" + version);
            }
            JModuleUtils.destroyQuietly(module);
            if (runtimeModule.count() == 0) {
                this.modules.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JModule find(String name) {
        JAssert.checkNotNull(name, "module name must not be null");
        Object object = this.getLock(name);
        synchronized (object) {
            JRuntimeModule runtimeModule = this.modules.get(name);
            if (runtimeModule == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name);
            }
            JModule module = runtimeModule.getDefaultModule();
            if (module == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name);
            }
            return module;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JModule find(String name, String version) {
        JAssert.checkNotNull(name, "module name must not be null");
        JAssert.checkNotNull(version, "module version must not be null");
        Object object = this.getLock(name);
        synchronized (object) {
            JRuntimeModule runtimeModule = this.modules.get(name);
            if (runtimeModule == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name);
            }
            JModule module = runtimeModule.findModule(version);
            if (module == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name + " and version:" + version);
            }
            return module;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeVersion(String name, String version) {
        JAssert.checkNotNull(name, "module name must not be null");
        JAssert.checkNotNull(version, "module version must not be null");
        Object object = this.getLock(name);
        synchronized (object) {
            JRuntimeModule runtimeModule = this.modules.get(name);
            if (runtimeModule == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name);
            }
            runtimeModule.setDefaultVersion(version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getActiveVersion(String name) {
        JAssert.checkNotNull(name, "module name must not be null");
        Object object = this.getLock(name);
        synchronized (object) {
            JRuntimeModule runtimeModule = this.modules.get(name);
            if (runtimeModule == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name);
            }
            return runtimeModule.getDefaultVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(String name) {
        if (name == null) {
            return false;
        }
        Object object = this.getLock(name);
        synchronized (object) {
            return this.modules.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(String name, String version) {
        if (name == null || version == null) {
            return false;
        }
        Object object = this.getLock(name);
        synchronized (object) {
            return this.modules.containsKey(name) && this.modules.get(name).hasVersion(version);
        }
    }

    @Override
    public Set<String> getModuleNames() {
        return Collections.unmodifiableSet(this.modules.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getModuleVersions(String name) {
        JAssert.checkNotNull(name, "module name must not be null");
        Object object = this.getLock(name);
        synchronized (object) {
            JRuntimeModule runtimeModule = this.modules.get(name);
            if (runtimeModule == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name);
            }
            Collection<JModule> modules = runtimeModule.list();
            if (modules == null) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> versions = new HashSet<String>();
            for (String version : versions) {
                versions.add(version);
            }
            return versions;
        }
    }

    @Override
    public Set<JModule> getModules() {
        HashSet<JModule> modules = new HashSet<JModule>();
        for (JRuntimeModule runtimeModule : this.modules.values()) {
            modules.addAll(runtimeModule.list());
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<JModule> getModules(String name) {
        JAssert.checkNotNull(name, "module name must not be null");
        Object object = this.getLock(name);
        synchronized (object) {
            JRuntimeModule runtimeModule = this.modules.get(name);
            if (runtimeModule == null) {
                throw new JModuleNotFoundException("could not found module with name:" + name);
            }
            HashSet<JModule> modules = new HashSet<JModule>();
            modules.addAll(runtimeModule.list());
            return modules;
        }
    }

    protected Object getLock(String uid) {
        Object newLock;
        Object lock = this;
        if (this.parallelLockMap != null && (lock = this.parallelLockMap.putIfAbsent(uid, newLock = new Object())) == null) {
            lock = newLock;
        }
        return lock;
    }
}

