/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl;

import com.jianggujin.modulelink.JAction;
import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.JModuleLinkException;
import com.jianggujin.modulelink.impl.JAbstractModule;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.JResolverUtils;
import com.jianggujin.modulelink.util.JStringUtils;
import java.lang.reflect.Modifier;
import java.util.Set;

public class JModuleImpl
extends JAbstractModule {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JModuleImpl.class);
    protected ClassLoader classLoader;

    public JModuleImpl(JModuleConfig moduleConfig, ClassLoader classLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(moduleConfig);
        String actionName;
        this.classLoader = classLoader;
        Set<String> scanPackages = moduleConfig.getScanPackages();
        Set<String> actions = moduleConfig.getActions();
        Set<String> exclusionActions = moduleConfig.getExclusionActions();
        if (!scanPackages.isEmpty()) {
            JResolverUtils utils = new JResolverUtils();
            utils.setClassLoader(this.classLoader);
            utils.setExclusions(exclusionActions);
            utils.addExclusions(actions);
            utils.findImplementations(JAction.class, scanPackages.toArray(new String[0]));
            for (Class<?> clazz : utils.getClasses()) {
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
                JAction action = (JAction)clazz.newInstance();
                actionName = action.getActionName();
                if (JStringUtils.isBlank(actionName)) {
                    throw new JModuleLinkException("JModuleLink scan actions actionName must not be null");
                }
                JAssert.checkState(!this.hasAction(actionName), "duplicated action %s found by: %s", JAction.class.getSimpleName(), actionName);
                if (logger.isInfoEnabled()) {
                    logger.info("JModuleLink scan action: " + actionName + ", bean: " + action);
                }
                if (this.defaultAction == null && action.isDefault(moduleConfig.getName())) {
                    this.defaultAction = action;
                }
                this.actions.put(actionName, action);
            }
        }
        if (!actions.isEmpty()) {
            for (String action : actions) {
                Class<?> clazz;
                if (exclusionActions.contains(action) || (clazz = this.classLoader.loadClass(action)).isInterface() || !JAction.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
                JAction ins = (JAction)clazz.newInstance();
                actionName = ins.getActionName();
                if (JStringUtils.isBlank(actionName)) {
                    throw new JModuleLinkException("JModuleLink load action actionName must not be null");
                }
                JAssert.checkState(!this.hasAction(actionName), "duplicated action %s found by: %s", JAction.class.getSimpleName(), actionName);
                if (logger.isInfoEnabled()) {
                    logger.info("JModuleLink load action: " + actionName + ", bean: " + ins);
                }
                if (this.defaultAction == null && ins.isDefault(moduleConfig.getName())) {
                    this.defaultAction = ins;
                }
                this.actions.put(actionName, ins);
            }
        }
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        return this.classLoader;
    }
}

