/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl;

import com.jianggujin.modulelink.JModule;
import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.JModuleLinkException;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JRuntimeModule {
    private final String name;
    private String defaultVersion;
    private Object moduleObj;

    public JRuntimeModule(String name) {
        this.name = name;
    }

    public JModule findModule(String version) {
        return this.findModule0(version);
    }

    private JModule findModule0(String version) {
        if (this.moduleObj != null) {
            if (this.moduleObj instanceof JModule) {
                JModule module = (JModule)this.moduleObj;
                return module.getModuleConfig().getVersion().equals(version) ? module : null;
            }
            Map modules = (Map)this.moduleObj;
            return (JModule)modules.get(version);
        }
        return null;
    }

    public boolean hasVersion(String version) {
        if (version == null) {
            return false;
        }
        return this.findModule0(version) != null;
    }

    public JModule getDefaultModule() {
        return this.findModule0(this.defaultVersion);
    }

    public synchronized void add(JModule module) {
        JModuleConfig moduleConfig = module.getModuleConfig();
        String name = moduleConfig.getName();
        String version = moduleConfig.getVersion();
        JAssert.checkState(name.equals(this.name) && !this.hasVersion(moduleConfig.getVersion()), "duplicated module, name:%s, version %s", name, version);
        if (this.moduleObj == null) {
            this.moduleObj = module;
            this.defaultVersion = version;
        } else if (this.moduleObj instanceof JModule) {
            JModule old = (JModule)this.moduleObj;
            ConcurrentHashMap<String, JModule> modules = new ConcurrentHashMap<String, JModule>();
            modules.put(old.getModuleConfig().getVersion(), old);
            modules.put(version, module);
            this.moduleObj = modules;
        } else {
            Map modules = (Map)this.moduleObj;
            modules.put(version, module);
        }
        if (moduleConfig.isActive()) {
            this.defaultVersion = version;
        }
    }

    public synchronized JModule remove(String version) {
        if (this.moduleObj instanceof JModule) {
            if (this.defaultVersion.equals(version)) {
                this.defaultVersion = null;
                JModule module = (JModule)this.moduleObj;
                this.moduleObj = null;
                return module;
            }
            return null;
        }
        if (this.moduleObj instanceof Map) {
            Map modules = (Map)this.moduleObj;
            if (modules.size() > 2 && JStringUtils.equals(version, this.defaultVersion)) {
                throw new JModuleLinkException("module has version more than 2, default version could not allow remove.");
            }
            JModule module = (JModule)modules.remove(version);
            if (modules.size() == 1) {
                this.moduleObj = modules.remove(this.defaultVersion);
            }
            return module;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public synchronized void setDefaultVersion(String defaultVersion) {
        JAssert.checkState(this.hasVersion(defaultVersion), "could not found version:" + defaultVersion);
        this.defaultVersion = defaultVersion;
    }

    public JRuntimeModule withDefaultVersion(String defaultVersion) {
        this.setDefaultVersion(defaultVersion);
        return this;
    }

    private Collection<JModule> list0() {
        if (this.moduleObj == null) {
            return null;
        }
        if (this.moduleObj instanceof JModule) {
            ArrayList<JModule> list = new ArrayList<JModule>();
            list.add((JModule)this.moduleObj);
            return list;
        }
        Map modules = (Map)this.moduleObj;
        return modules.values();
    }

    public Collection<JModule> list() {
        return this.list0();
    }

    public int count() {
        return this.moduleObj == null ? 0 : (this.moduleObj instanceof JModule ? 1 : ((Map)this.moduleObj).size());
    }

    public Collection<JModule> clear() {
        this.defaultVersion = null;
        Collection<JModule> list = this.list0();
        if (this.moduleObj instanceof Map) {
            Map modules = (Map)this.moduleObj;
            modules.clear();
        }
        this.moduleObj = null;
        return list;
    }
}

