/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl.spring;

import com.jianggujin.modulelink.JAction;
import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.JModuleLinkException;
import com.jianggujin.modulelink.impl.JAbstractModule;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.JStringUtils;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.context.ConfigurableApplicationContext;

public class JSpringModule
extends JAbstractModule {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JSpringModule.class);
    private final ConfigurableApplicationContext applicationContext;

    public JSpringModule(JModuleConfig moduleConfig, ConfigurableApplicationContext applicationContext) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        super(moduleConfig);
        this.applicationContext = applicationContext;
        Set<String> actions = moduleConfig.getActions();
        Set<String> exclusionActions = moduleConfig.getExclusionActions();
        HashSet<String> loadedActions = new HashSet<String>();
        applicationContext.getBeanFactory();
        for (JAction jAction : applicationContext.getBeansOfType(JAction.class).values()) {
            String className = jAction.getClass().getName();
            if (exclusionActions.contains(className)) continue;
            String actionName = jAction.getActionName();
            if (JStringUtils.isBlank(actionName)) {
                throw new JModuleLinkException("JModuleLink scan actions actionName is null");
            }
            JAssert.checkState(!this.actions.containsKey(actionName), "duplicated action %s found by: %s", JAction.class.getSimpleName(), actionName);
            if (logger.isInfoEnabled()) {
                logger.info("JModuleLink scan action: " + actionName + ": bean: " + jAction);
            }
            if (this.defaultAction == null && jAction.isDefault(moduleConfig.getName())) {
                this.defaultAction = jAction;
            }
            loadedActions.add(className);
            this.actions.put(actionName, jAction);
        }
        if (logger.isInfoEnabled()) {
            logger.info("JModuleLink scan actions finish: " + this.actions);
        }
        loadedActions.addAll(exclusionActions);
        if (!actions.isEmpty()) {
            for (String string : actions) {
                Class<?> clazz;
                if (loadedActions.contains(string) || (clazz = this.applicationContext.getClassLoader().loadClass(string)).isInterface() || !JAction.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
                JAction ins = (JAction)clazz.newInstance();
                String actionName = ins.getActionName();
                if (JStringUtils.isBlank(actionName)) {
                    throw new JModuleLinkException("JModuleLink load action actionName must not be null");
                }
                JAssert.checkState(!this.actions.containsKey(actionName), "duplicated action %s found by: %s", JAction.class.getSimpleName(), actionName);
                if (logger.isInfoEnabled()) {
                    logger.info("JModuleLink load action: " + actionName + ", bean: " + ins);
                }
                if (this.defaultAction == null && ins.isDefault(moduleConfig.getName())) {
                    this.defaultAction = ins;
                }
                this.actions.put(actionName, ins);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("JModuleLink load actions finish: " + this.actions);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (logger.isInfoEnabled()) {
            logger.info("close application context: " + this.applicationContext);
        }
        JSpringModule.closeQuietly(this.applicationContext);
        JSpringModule.clear(this.applicationContext.getClassLoader());
    }

    private static void clear(ClassLoader classLoader) {
        JAssert.checkNotNull(classLoader, "classLoader must not be null.");
        CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
        LogFactory.release((ClassLoader)classLoader);
    }

    private static void closeQuietly(ConfigurableApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is null");
        }
        try {
            applicationContext.close();
        }
        catch (Exception e) {
            logger.error("failed to close application context", e);
        }
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        return this.applicationContext.getClassLoader();
    }
}

