/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl.spring;

import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.util.JAssert;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSpringModuleConfig
extends JModuleConfig {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Set<String> xmlPatterns = new HashSet<String>();
    private Set<String> exclusions = new HashSet<String>();

    public JSpringModuleConfig(String name, String version) {
        super(name, version);
    }

    public JSpringModuleConfig(JModuleConfig moduleConfig) {
        super(moduleConfig.getName(), moduleConfig.getName());
        this.setDesc(moduleConfig.getDesc());
        this.setModuleUrls(moduleConfig.getModuleUrls());
        this.setScanPackages(moduleConfig.getScanPackages());
        this.setActions(moduleConfig.getActions());
        this.setExclusionActions(moduleConfig.getExclusionActions());
        this.setActive(moduleConfig.isActive());
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        JAssert.checkNotNull(properties, "properties must not be null");
        this.properties = properties;
    }

    public JSpringModuleConfig withProperties(Map<String, Object> properties) {
        this.setProperties(properties);
        return this;
    }

    public JSpringModuleConfig addProperties(Map<String, ? extends Object> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public JSpringModuleConfig addProperty(String name, Object value) {
        JAssert.checkNotNull(name, "name must not be null");
        JAssert.checkNotNull(value, "value must not be null");
        this.properties.put(name, value);
        return this;
    }

    public JSpringModuleConfig removeProperty(String name) {
        this.properties.remove(name);
        return this;
    }

    public Set<String> getXmlPatterns() {
        return this.xmlPatterns;
    }

    public void setXmlPatterns(Set<String> xmlPatterns) {
        JAssert.checkNotNull(xmlPatterns, "xmlPatterns must not be null");
        this.xmlPatterns = xmlPatterns;
    }

    public JSpringModuleConfig withXmlPatterns(Set<String> xmlPatterns) {
        this.setXmlPatterns(xmlPatterns);
        return this;
    }

    public JSpringModuleConfig addXmlPatterns(Collection<? extends String> xmlPatterns) {
        if (xmlPatterns != null) {
            this.xmlPatterns.addAll(xmlPatterns);
        }
        return this;
    }

    public JSpringModuleConfig addXmlPattern(String xmlPattern) {
        JAssert.checkNotNull(xmlPattern, "xmlPattern must not be null");
        this.xmlPatterns.add(xmlPattern);
        return this;
    }

    public JSpringModuleConfig removeXmlPattern(String xmlPattern) {
        this.xmlPatterns.remove(xmlPattern);
        return this;
    }

    public Set<String> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Set<String> exclusions) {
        JAssert.checkNotNull(exclusions, "exclusions must not be null");
        this.exclusions = exclusions;
    }

    public JSpringModuleConfig withExclusions(Set<String> exclusions) {
        this.setExclusions(exclusions);
        return this;
    }

    public JSpringModuleConfig addExclusions(Collection<? extends String> exclusions) {
        if (exclusions != null) {
            this.exclusions.addAll(exclusions);
        }
        return this;
    }

    public JSpringModuleConfig addExclusion(String exclusion) {
        JAssert.checkNotNull(exclusion, "exclusion must not be null");
        this.exclusions.add(exclusion);
        return this;
    }

    public JSpringModuleConfig removeExclusion(String exclusion) {
        this.exclusions.remove(exclusion);
        return this;
    }

    public List<String> getModuleUrlPath() {
        ArrayList<String> moduleUrls = new ArrayList<String>();
        for (URL url : this.getModuleUrls()) {
            moduleUrls.add(url.toString());
        }
        return moduleUrls;
    }

    @Override
    public String toString() {
        return "JSpringModuleConfig [properties=" + this.properties + ", xmlPatterns=" + this.xmlPatterns + ", exclusions=" + this.exclusions + ", toString()=" + super.toString() + "]";
    }
}

