/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl.spring;

import com.jianggujin.modulelink.JModule;
import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.JModuleManager;
import com.jianggujin.modulelink.impl.JAbstractModuleManager;
import com.jianggujin.modulelink.impl.JModuleImpl;
import com.jianggujin.modulelink.impl.spring.JModuleAnnotationApplicationContext;
import com.jianggujin.modulelink.impl.spring.JModuleXmlApplicationContext;
import com.jianggujin.modulelink.impl.spring.JSpringModule;
import com.jianggujin.modulelink.impl.spring.JSpringModuleConfig;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.JModuleClassLoader;
import com.jianggujin.modulelink.util.JStringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class JSpringModuleManager
extends JAbstractModuleManager
implements ApplicationContextAware,
InitializingBean {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JSpringModuleManager.class);
    private static JModuleManager instance = null;
    public static final String[] SPRING_XML_PATTERN = new String[]{"classpath*:META-INF/spring/*.xml", "classpath*:*META-INF/spring/*.xml"};
    private ApplicationContext applicationContext;

    @Override
    protected JModuleClassLoader createModuleClassLoader(JModuleConfig moduleConfig) {
        return new JModuleClassLoader(moduleConfig.getModuleUrls(), this.applicationContext.getClassLoader());
    }

    @Override
    protected JModule load(JModuleConfig moduleConfig, ClassLoader moduleClassLoader) throws Exception {
        if (moduleConfig instanceof JSpringModuleConfig) {
            Object context;
            JSpringModuleConfig springModuleConfig = (JSpringModuleConfig)moduleConfig;
            Properties properties = this.getProperties(springModuleConfig);
            Set<String> scanBase = springModuleConfig.getScanPackages();
            if (!scanBase.isEmpty()) {
                context = new JModuleAnnotationApplicationContext(properties);
                ((JModuleAnnotationApplicationContext)((Object)context)).scan(scanBase.toArray(new String[0]));
            } else {
                context = new JModuleXmlApplicationContext();
                ((JModuleXmlApplicationContext)((Object)context)).setProperties(properties);
                String[] locations = this.findSpringConfigs(springModuleConfig, moduleClassLoader);
                ((JModuleXmlApplicationContext)((Object)context)).setConfigLocations(locations);
            }
            context.setParent(this.applicationContext);
            if (logger.isInfoEnabled()) {
                logger.info("module " + moduleConfig.getName() + ":" + moduleConfig.getVersion() + " allow current process to override bean in module");
            }
            ((DefaultResourceLoader)context).setClassLoader(moduleClassLoader);
            context.refresh();
            return new JSpringModule(moduleConfig, (ConfigurableApplicationContext)context);
        }
        return new JModuleImpl(moduleConfig, moduleClassLoader);
    }

    @Override
    protected void loadModuleError(ClassLoader moduleClassLoader) {
        super.loadModuleError(moduleClassLoader);
        CachedIntrospectionResults.clearClassLoader((ClassLoader)moduleClassLoader);
    }

    private Properties getProperties(JSpringModuleConfig moduleConfig) {
        Properties properties = JSpringModuleManager.toProperties(moduleConfig.getProperties());
        if (logger.isInfoEnabled()) {
            logger.info("module Properties: " + properties);
        }
        return properties;
    }

    private String[] findSpringConfigs(JSpringModuleConfig moduleConfig, ClassLoader moduleClassLoader) {
        List<String> tempFileJarURLs = moduleConfig.getModuleUrlPath();
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver pmr = new PathMatchingResourcePatternResolver(moduleClassLoader);
            ArrayList<Resource> list = new ArrayList<Resource>();
            Set<String> xmlPatterns = moduleConfig.getXmlPatterns();
            if (xmlPatterns.isEmpty()) {
                for (String locationPattern : SPRING_XML_PATTERN) {
                    list.addAll(Arrays.asList(pmr.getResources(locationPattern)));
                }
            } else {
                for (String locationPattern : xmlPatterns) {
                    list.addAll(Arrays.asList(pmr.getResources(locationPattern)));
                }
            }
            JAssert.checkArgument((resources = list.toArray(new Resource[0])).length > 0, "resources length is 0");
            return this.filterURLsIncludedResources(tempFileJarURLs, resources, moduleConfig.getExclusions());
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to find spring configs from " + tempFileJarURLs, e);
        }
    }

    private String[] filterURLsIncludedResources(List<String> tempFileJarURLs, Resource[] resources, Set<String> exclusionConfigeNameList) throws IOException {
        ArrayList<String> configLocations = new ArrayList<String>();
        for (Resource resource : resources) {
            String configLocation = resource.getURL().toString();
            for (String url : tempFileJarURLs) {
                if (this.isExclusionConfig(configLocation, exclusionConfigeNameList)) {
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("exclusion url: " + configLocation);
                    continue;
                }
                if (!configLocation.contains(url)) continue;
                configLocations.add(configLocation);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("config locations: " + configLocations);
        }
        return configLocations.toArray(new String[0]);
    }

    private boolean isExclusionConfig(String url, Set<String> exclusionConfigeNameList) {
        for (String tmp : exclusionConfigeNameList) {
            if (!url.contains(tmp)) continue;
            return true;
        }
        return false;
    }

    private static Properties toProperties(Map<String, Object> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> each : map.entrySet()) {
            if (each.getKey() == null || each.getValue() == null) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn("ignore null properties: " + each.getKey() + "=" + each.getValue());
                continue;
            }
            if (JStringUtils.isBlank(each.getKey())) continue;
            properties.setProperty(each.getKey(), each.getValue().toString());
        }
        return properties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        instance = this;
    }

    public static JModuleManager getInstance() {
        return instance;
    }
}

