/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl.web;

import com.jianggujin.modulelink.JAction;
import com.jianggujin.modulelink.JModule;
import com.jianggujin.modulelink.impl.web.JWebModuleConfig;
import com.jianggujin.modulelink.util.JEnumeration;
import com.jianggujin.modulelink.util.JStringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class JDelegatingServletContext
implements ServletContext {
    private final ServletContext servletContext;
    private final JModule module;
    private final JWebModuleConfig moduleConfig;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final String servletContextName;

    public JDelegatingServletContext(ServletContext servletContext, JModule module, JWebModuleConfig moduleConfig) {
        this.servletContext = servletContext;
        this.module = module;
        this.moduleConfig = moduleConfig;
        this.servletContextName = moduleConfig.getName() + "-" + moduleConfig.getVersion();
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public int getEffectiveMajorVersion() {
        return this.getMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.getMinorVersion();
    }

    public int getMajorVersion() {
        return this.servletContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.servletContext.getMinorVersion();
    }

    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        HashSet<String> paths = new HashSet<String>(this.servletContext.getResourcePaths(path));
        String webRootPath = this.moduleConfig.getWebRootPath();
        if (!JStringUtils.isEmpty(webRootPath)) {
            File root = new File(this.moduleConfig.getWebRootPath(), path);
            int prefixLen = root.getAbsolutePath().length();
            File[] list = root.listFiles();
            if (list != null) {
                for (File file : list) {
                    this.listPaths(paths, file, prefixLen);
                }
            }
        }
        return paths;
    }

    private void listPaths(Set<String> paths, File root, int prefixLen) {
        if (root.isFile()) {
            paths.add(root.getAbsolutePath().substring(prefixLen));
        } else {
            paths.add(root.getAbsolutePath().substring(prefixLen) + "/");
            File[] list = root.listFiles();
            if (list != null) {
                for (File file : list) {
                    this.listPaths(paths, file, prefixLen);
                }
            }
        }
    }

    public URL getResource(String path) throws MalformedURLException {
        File file;
        String webRootPath = this.moduleConfig.getWebRootPath();
        if (!JStringUtils.isEmpty(webRootPath) && (file = new File(webRootPath, path)).exists()) {
            return file.toURI().toURL();
        }
        return this.servletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        File file;
        String webRootPath = this.moduleConfig.getWebRootPath();
        if (!JStringUtils.isEmpty(webRootPath) && (file = new File(webRootPath, path)).exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.servletContext.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.servletContext.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.servletContext.getNamedDispatcher(name);
    }

    public Servlet getServlet(String name) throws ServletException {
        JAction action = this.module.findAction(name);
        if (action instanceof Servlet) {
            return (Servlet)action;
        }
        return this.servletContext.getServlet(name);
    }

    public Enumeration<Servlet> getServlets() {
        Enumeration servlets = this.servletContext.getServlets();
        HashMap<String, Servlet> map = new HashMap<String, Servlet>();
        if (servlets != null) {
            while (servlets.hasMoreElements()) {
                Servlet servlet = (Servlet)servlets.nextElement();
                map.put(servlet.getServletConfig().getServletName(), servlet);
            }
        }
        for (String name : this.module.getActionNames()) {
            JAction action = this.module.findAction(name);
            if (!(action instanceof Servlet)) continue;
            Servlet servlet = (Servlet)action;
            map.put(servlet.getServletConfig().getServletName(), servlet);
        }
        return new JEnumeration<Servlet>(map.values());
    }

    public Enumeration<String> getServletNames() {
        Enumeration servlets = this.servletContext.getServletNames();
        HashSet set = new HashSet();
        if (servlets != null) {
            while (servlets.hasMoreElements()) {
                set.add(servlets.nextElement());
            }
        }
        for (String name : this.module.getActionNames()) {
            JAction action = this.module.findAction(name);
            if (!(action instanceof Servlet)) continue;
            set.add(name);
        }
        return new JEnumeration<String>(set);
    }

    public void log(String msg) {
        this.servletContext.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.servletContext.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }

    public String getRealPath(String path) {
        String webRootPath = this.moduleConfig.getWebRootPath();
        if (!JStringUtils.isEmpty(webRootPath)) {
            return new File(webRootPath, path).getAbsolutePath();
        }
        throw new UnsupportedOperationException("webRootPath not set.");
    }

    public String getServerInfo() {
        return this.servletContext.getServerInfo();
    }

    public String getInitParameter(String name) {
        String value = this.moduleConfig.getInitParameters().get(name);
        if (value == null) {
            return this.servletContext.getInitParameter(name);
        }
        return value;
    }

    public Enumeration<String> getInitParameterNames() {
        Enumeration servlets = this.servletContext.getInitParameterNames();
        HashSet set = new HashSet();
        if (servlets != null) {
            while (servlets.hasMoreElements()) {
                set.add(servlets.nextElement());
            }
        }
        for (String name : this.moduleConfig.getInitParameters().keySet()) {
            set.add(name);
        }
        return new JEnumeration<String>(set);
    }

    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (value == null) {
            return this.servletContext.getAttribute(name);
        }
        return value;
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration names = this.servletContext.getAttributeNames();
        HashSet set = new HashSet();
        if (names != null) {
            while (names.hasMoreElements()) {
                set.add(names.nextElement());
            }
        }
        set.addAll(this.attributes.keySet());
        return new JEnumeration<String>(set);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.servletContextName;
    }
}

