/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl.web;

import com.jianggujin.modulelink.JAction;
import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.JModuleLinkException;
import com.jianggujin.modulelink.impl.JAbstractModule;
import com.jianggujin.modulelink.impl.web.JDelegatingServletContext;
import com.jianggujin.modulelink.impl.web.JServletConfig;
import com.jianggujin.modulelink.impl.web.JWebContext;
import com.jianggujin.modulelink.impl.web.JWebModuleConfig;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.JModuleUtils;
import com.jianggujin.modulelink.util.JResolverUtils;
import com.jianggujin.modulelink.util.JStringUtils;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JWebModule
extends JAbstractModule {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JWebModule.class);
    protected ClassLoader classLoader;
    private JDelegatingServletContext context;
    private JWebModuleConfig webModuleConfig;

    public JWebModule(JModuleConfig moduleConfig, ClassLoader classLoader, ServletContext servletContext) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(moduleConfig);
        String actionName;
        this.classLoader = classLoader;
        this.webModuleConfig = (JWebModuleConfig)moduleConfig;
        this.context = new JDelegatingServletContext(servletContext, this, this.webModuleConfig);
        Set<String> scanPackages = moduleConfig.getScanPackages();
        Set<String> actions = moduleConfig.getActions();
        Set<String> exclusionActions = moduleConfig.getExclusionActions();
        if (!scanPackages.isEmpty()) {
            JResolverUtils utils = new JResolverUtils();
            utils.setClassLoader(this.classLoader);
            utils.setExclusions(exclusionActions);
            utils.addExclusions(actions);
            utils.findImplementations(JAction.class, scanPackages.toArray(new String[0]));
            for (Class<?> clazz : utils.getClasses()) {
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
                JAction action = (JAction)clazz.newInstance();
                actionName = action.getActionName();
                if (JStringUtils.isBlank(actionName)) {
                    throw new JModuleLinkException("JModuleLink scan actions actionName must not be null");
                }
                JAssert.checkState(!this.hasAction(actionName), "duplicated action %s found by: %s", JAction.class.getSimpleName(), actionName);
                if (logger.isInfoEnabled()) {
                    logger.info("JModuleLink scan action: " + actionName + ", bean: " + action);
                }
                if (this.defaultAction == null && action.isDefault(moduleConfig.getName())) {
                    this.defaultAction = action;
                }
                this.addAction(actionName, action);
            }
        }
        if (!actions.isEmpty()) {
            for (String action : actions) {
                Class<?> clazz;
                if (exclusionActions.contains(action) || (clazz = this.classLoader.loadClass(action)).isInterface() || !JAction.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
                JAction ins = (JAction)clazz.newInstance();
                actionName = ins.getActionName();
                if (JStringUtils.isBlank(actionName)) {
                    throw new JModuleLinkException("JModuleLink load action actionName must not be null");
                }
                JAssert.checkState(!this.hasAction(actionName), "duplicated action %s found by: %s", JAction.class.getSimpleName(), actionName);
                if (logger.isInfoEnabled()) {
                    logger.info("JModuleLink load action: " + actionName + ", bean: " + ins);
                }
                if (this.defaultAction == null && ins.isDefault(moduleConfig.getName())) {
                    this.defaultAction = ins;
                }
                this.addAction(actionName, ins);
            }
        }
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        return this.classLoader;
    }

    private void addAction(String name, JAction action) {
        if (action instanceof Servlet) {
            Servlet servlet = (Servlet)action;
            try {
                servlet.init((ServletConfig)new JServletConfig(action, this.context, this.webModuleConfig.getServletInitParameters(action.getActionName())));
            }
            catch (ServletException e) {
                throw new JModuleLinkException(e);
            }
        }
        this.actions.put(name, action);
    }

    public Object doServletAction(String actionName, ServletRequest request, ServletResponse response) {
        JAssert.checkNotNull(actionName, "actionName must not be null");
        return JModuleUtils.doActionWithinModuleClassLoader((JAction)this.actions.get(actionName), new JWebContext(request, response));
    }

    public Object doDefaultAction(ServletRequest request, ServletResponse response) {
        return JModuleUtils.doActionWithinModuleClassLoader(this.defaultAction, new JWebContext(request, response));
    }

    @Override
    public void destroy() {
        for (Map.Entry entry : this.actions.entrySet()) {
            if (!(entry.getValue() instanceof Servlet)) continue;
            Servlet servlet = (Servlet)entry.getValue();
            servlet.destroy();
        }
        super.destroy();
    }
}

