/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.impl.web;

import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.util.JAssert;
import java.util.HashMap;
import java.util.Map;

public class JWebModuleConfig
extends JModuleConfig {
    private Map<String, String> initParameters = new HashMap<String, String>();
    private Map<String, Map<String, String>> servletInitParameters = new HashMap<String, Map<String, String>>();
    private String webRootPath;

    public JWebModuleConfig(String name, String version, String webRootPath) {
        super(name, version);
        JAssert.checkNotNull(webRootPath, "webRootPath must not be null");
        this.webRootPath = webRootPath;
    }

    public JWebModuleConfig(JModuleConfig moduleConfig, String webRootPath) {
        super(moduleConfig.getName(), moduleConfig.getName());
        this.setDesc(moduleConfig.getDesc());
        this.setModuleUrls(moduleConfig.getModuleUrls());
        this.setScanPackages(moduleConfig.getScanPackages());
        this.setActions(moduleConfig.getActions());
        this.setExclusionActions(moduleConfig.getExclusionActions());
        this.setActive(moduleConfig.isActive());
        JAssert.checkNotNull(webRootPath, "webRootPath must not be null");
        this.webRootPath = webRootPath;
    }

    public String getWebRootPath() {
        return this.webRootPath;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        JAssert.checkNotNull(initParameters, "initParameters must not be null");
        this.initParameters = initParameters;
    }

    public JWebModuleConfig withInitParameters(Map<String, String> initParameters) {
        this.setInitParameters(initParameters);
        return this;
    }

    public JWebModuleConfig addInitParameters(Map<String, String> initParameters) {
        if (initParameters != null) {
            this.initParameters.putAll(initParameters);
        }
        return this;
    }

    public JWebModuleConfig addInitParameter(String name, String value) {
        JAssert.checkNotNull(name, "name must not be null");
        this.initParameters.put(name, value);
        return this;
    }

    public JWebModuleConfig removeInitParameter(String name) {
        this.initParameters.remove(name);
        return this;
    }

    public Map<String, String> getServletInitParameters(String name) {
        return this.servletInitParameters.get(name);
    }

    public Map<String, Map<String, String>> getServletInitParameters() {
        return this.servletInitParameters;
    }

    public void setServletInitParameters(String actionClass, Map<String, String> initParameters) {
        JAssert.checkNotNull(actionClass, "actionClass must not be null");
        JAssert.checkNotNull(initParameters, "initParameters must not be null");
        this.servletInitParameters.put(actionClass, initParameters);
    }

    public JWebModuleConfig withServletInitParameters(String actionClass, Map<String, String> initParameters) {
        this.setServletInitParameters(actionClass, initParameters);
        return this;
    }

    public JWebModuleConfig addServletInitParameters(String actionClass, Map<String, String> initParameters) {
        JAssert.checkNotNull(actionClass, "actionClass must not be null");
        if (initParameters != null) {
            Map<String, String> pas = this.servletInitParameters.get(actionClass);
            if (pas == null) {
                pas = new HashMap<String, String>();
                this.servletInitParameters.put(actionClass, pas);
            }
            pas.putAll(initParameters);
        }
        return this;
    }

    public JWebModuleConfig addServletInitParameter(String actionClass, String name, String value) {
        JAssert.checkNotNull(actionClass, "actionClass must not be null");
        JAssert.checkNotNull(name, "name must not be null");
        if (value != null) {
            Map<String, String> pas = this.servletInitParameters.get(actionClass);
            if (pas == null) {
                pas = new HashMap<String, String>();
                this.servletInitParameters.put(actionClass, pas);
            }
            pas.put(name, value);
        }
        return this;
    }

    public JWebModuleConfig removeServletInitParameter(String actionClass, String name) {
        Map<String, String> pas = this.servletInitParameters.get(actionClass);
        if (pas != null) {
            pas.remove(name);
        }
        return this;
    }

    public JWebModuleConfig removeServletInitParameter(String actionClass) {
        this.servletInitParameters.remove(actionClass);
        return this;
    }
}

