/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util;

import com.jianggujin.modulelink.JModule;
import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.JModuleManager;
import com.jianggujin.modulelink.impl.JAbstractModuleManager;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JDefaultMultiValueMap;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.JMultiValueMap;
import com.jianggujin.modulelink.util.JThreadFactory;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class JAbstractModuleRefreshScheduler
implements Runnable {
    private final JLogFactory.JLog logger = JLogFactory.getLog(JAbstractModuleRefreshScheduler.class);
    private static final int DEFAULT_INITIAL_DELAY = 5;
    private static final int DEFAULT_REFRESH_DELAY = 60;
    private int initialDelay = 5;
    private int refreshDelay = 60;
    private ScheduledExecutorService scheduledExecutor;
    private boolean enableScheduled = true;
    private final JModuleManager moduleManager;

    public JAbstractModuleRefreshScheduler(JAbstractModuleManager moduleManager) {
        JAssert.checkNotNull(moduleManager, "moduleManager must not be null.");
        this.moduleManager = moduleManager;
    }

    public void start() throws Exception {
        this.refreshModuleConfigs();
        if (this.enableScheduled) {
            this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, new JThreadFactory("JModuleLink_refresh-schedule-"));
            this.scheduledExecutor.scheduleWithFixedDelay(this, this.initialDelay, this.refreshDelay, TimeUnit.SECONDS);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("JAbstractModuleRefreshScheduler start");
            }
        }
    }

    public void destroy() throws Exception {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
    }

    @Override
    public void run() {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Start Module refresh");
            }
            this.refreshModuleConfigs();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Stop Module refresh");
            }
        }
        catch (Throwable e) {
            this.logger.error("Failed to refresh Module", e);
        }
    }

    protected void refreshModuleConfigs() {
        JDefaultMultiValueMap<String, String> queryVersions = new JDefaultMultiValueMap<String, String>();
        Set<JModuleConfig> queryConfigs = this.queryModuleConfigs(queryVersions);
        if (queryConfigs == null || queryConfigs.isEmpty()) {
            for (String name : this.moduleManager.getModuleNames()) {
                try {
                    this.moduleManager.unload(name);
                }
                catch (Exception e) {
                    this.logger.error("unload module error.", e);
                }
            }
            return;
        }
        if (this.moduleManager.getModuleNames().isEmpty()) {
            for (JModuleConfig moduleConfig : queryConfigs) {
                try {
                    this.moduleManager.load(moduleConfig);
                }
                catch (Exception e) {
                    this.logger.error("load module error.", e);
                }
            }
            return;
        }
        for (JModuleConfig moduleConfig : queryConfigs) {
            String name = moduleConfig.getName();
            if (this.moduleManager.has(name, moduleConfig.getVersion())) continue;
            try {
                this.moduleManager.load(moduleConfig);
            }
            catch (Exception e) {
                this.logger.error("load module error.", e);
            }
        }
        for (JModule module : this.moduleManager.getModules()) {
            JModuleConfig moduleConfig = module.getModuleConfig();
            String name = moduleConfig.getName();
            String version = moduleConfig.getVersion();
            if (queryVersions.containsKey(name)) {
                List versions = (List)queryVersions.get(name);
                if (versions.contains(version)) continue;
                try {
                    this.moduleManager.unload(name, version);
                }
                catch (Exception e) {
                    this.logger.error("unload module error.", e);
                }
                continue;
            }
            try {
                this.moduleManager.unload(name);
            }
            catch (Exception e) {
                this.logger.error("unload module error.", e);
            }
        }
    }

    protected Set<JModuleConfig> queryModuleConfigs(JMultiValueMap<String, String> queryVersions) {
        Set<JModuleConfig> moduleConfigs = this.queryModuleConfigs();
        if (moduleConfigs == null) {
            return null;
        }
        for (JModuleConfig moduleConfig : moduleConfigs) {
            queryVersions.add(moduleConfig.getName(), moduleConfig.getVersion());
        }
        return moduleConfigs;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    public boolean isEnableScheduled() {
        return this.enableScheduled;
    }

    public void setEnableScheduled(boolean enableScheduled) {
        this.enableScheduled = enableScheduled;
    }

    public abstract Set<JModuleConfig> queryModuleConfigs();
}

