/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util;

import com.jianggujin.modulelink.util.JLoggingAdapter;
import java.lang.reflect.Constructor;

public final class JLogFactory {
    private static Constructor<? extends JLog> logConstructor;

    private JLogFactory() {
    }

    public static JLog getLog(Class<?> aClass) {
        return JLogFactory.getLog(aClass.getName());
    }

    public static JLog getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Throwable t) {
            throw new JLogException("Error creating logger for logger " + logger + ".  Cause: " + t, t);
        }
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setImplementation(Class<? extends JLog> implClass) {
        try {
            Constructor<? extends JLog> candidate = implClass.getConstructor(String.class);
            JLog log = candidate.newInstance(JLogFactory.class.getName());
            if (log.isDebugEnabled()) {
                log.debug("Logging initialized using '" + implClass + "' adapter.");
            }
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new JLogException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    static {
        JLogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                JLogFactory.setImplementation(JLoggingAdapter.class);
            }
        });
        JLogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                JLogFactory.setImplementation(JStdOutImpl.class);
            }
        });
    }

    public static class JLogException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JLogException() {
        }

        public JLogException(String message) {
            super(message);
        }

        public JLogException(String message, Throwable cause) {
            super(message, cause);
        }

        public JLogException(Throwable cause) {
            super(cause);
        }
    }

    public static class JStdOutImpl
    implements JLog {
        private int level = 3;

        public JStdOutImpl(String clazz) {
            String level = System.getProperty("com.jianggujin.modulelink.util.JLogFactory.JStdOutImpl.level");
            if ("trace".equalsIgnoreCase(level)) {
                this.level = 1;
            } else if ("debug".equalsIgnoreCase(level)) {
                this.level = 2;
            } else if ("info".equalsIgnoreCase(level)) {
                this.level = 3;
            } else if ("warn".equalsIgnoreCase(level)) {
                this.level = 4;
            } else if ("error".equalsIgnoreCase(level)) {
                this.level = 5;
            }
        }

        @Override
        public boolean isTraceEnabled() {
            return this.level >= 1;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.level >= 2;
        }

        @Override
        public boolean isInfoEnabled() {
            return this.level >= 3;
        }

        @Override
        public boolean isWarnEnabled() {
            return this.level >= 4;
        }

        @Override
        public boolean isErrorEnabled() {
            return this.level >= 5;
        }

        @Override
        public void error(String s, Throwable e) {
            if (this.isErrorEnabled()) {
                System.err.println(s);
                e.printStackTrace(System.err);
            }
        }

        @Override
        public void error(String s) {
            if (this.isErrorEnabled()) {
                System.err.println(s);
            }
        }

        @Override
        public void debug(String s) {
            if (this.isDebugEnabled()) {
                System.out.println(s);
            }
        }

        @Override
        public void trace(String s) {
            if (this.isTraceEnabled()) {
                System.out.println(s);
            }
        }

        @Override
        public void warn(String s) {
            if (this.isWarnEnabled()) {
                System.out.println(s);
            }
        }

        @Override
        public void info(String s) {
            if (this.isInfoEnabled()) {
                System.out.println(s);
            }
        }

        @Override
        public void debug(String s, Throwable e) {
            if (this.isDebugEnabled()) {
                System.out.println(s);
                e.printStackTrace(System.out);
            }
        }

        @Override
        public void trace(String s, Throwable e) {
            if (this.isTraceEnabled()) {
                System.out.println(s);
                e.printStackTrace(System.out);
            }
        }

        @Override
        public void warn(String s, Throwable e) {
            if (this.isWarnEnabled()) {
                System.out.println(s);
                e.printStackTrace(System.out);
            }
        }

        @Override
        public void info(String s, Throwable e) {
            if (this.isInfoEnabled()) {
                System.out.println(s);
                e.printStackTrace(System.out);
            }
        }
    }

    public static interface JLog {
        public boolean isErrorEnabled();

        public boolean isInfoEnabled();

        public boolean isWarnEnabled();

        public boolean isDebugEnabled();

        public boolean isTraceEnabled();

        public void error(String var1);

        public void error(String var1, Throwable var2);

        public void debug(String var1);

        public void debug(String var1, Throwable var2);

        public void trace(String var1);

        public void trace(String var1, Throwable var2);

        public void warn(String var1);

        public void warn(String var1, Throwable var2);

        public void info(String var1);

        public void info(String var1, Throwable var2);
    }
}

