/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util;

import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JModuleClassLoader
extends URLClassLoader {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JModuleClassLoader.class);
    private final ConcurrentHashMap<String, Object> parallelLockMap;
    protected final ClassLoader parent;
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle."};
    private final Set<String> excludedPackages = new HashSet<String>();
    private static boolean canCloseJar = false;
    private static boolean registerAsParallelCapable = false;
    private final List<JarURLConnection> cachedJarFiles;

    public JModuleClassLoader(Set<URL> urls) {
        super(new URL[0]);
        ClassLoader p = this.getParent();
        if (p == null) {
            p = JModuleClassLoader.getSystemClassLoader();
        }
        this.parent = p;
        this.parallelLockMap = registerAsParallelCapable ? null : new ConcurrentHashMap();
        ArrayList arrayList = this.cachedJarFiles = canCloseJar ? null : new ArrayList();
        if (urls != null) {
            for (URL url : urls) {
                this.addURL(url);
            }
        }
        this.excludedPackages.addAll(new HashSet<String>(Arrays.asList(DEFAULT_EXCLUDED_PACKAGES)));
    }

    public JModuleClassLoader(Set<URL> urls, ClassLoader parent) {
        super(new URL[0], parent);
        ClassLoader p = this.getParent();
        if (p == null) {
            p = JModuleClassLoader.getSystemClassLoader();
        }
        this.parent = p;
        this.parallelLockMap = registerAsParallelCapable ? null : new ConcurrentHashMap();
        ArrayList arrayList = this.cachedJarFiles = canCloseJar ? null : new ArrayList();
        if (urls != null) {
            for (URL url : urls) {
                this.addURL(url);
            }
        }
        this.excludedPackages.addAll(new HashSet<String>(Arrays.asList(DEFAULT_EXCLUDED_PACKAGES)));
    }

    @Override
    protected void addURL(URL url) {
        if (!canCloseJar) {
            try {
                URLConnection uc = url.openConnection();
                if (uc instanceof JarURLConnection) {
                    uc.setUseCaches(true);
                    ((JarURLConnection)uc).getManifest();
                    this.cachedJarFiles.add((JarURLConnection)uc);
                }
            }
            catch (Exception e) {
                logger.error("Failed to cache JAR file:" + url.toExternalForm());
            }
        }
        super.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            if (this.isEligibleForOverriding(name)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Load class for overriding: " + name);
                }
                result = this.loadClassForOverriding(name, resolve);
            }
            if (result != null) {
                if (resolve) {
                    this.resolveClass(result);
                }
                return result;
            }
            return super.loadClass(name, resolve);
        }
    }

    private Class<?> loadClassForOverriding(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            try {
                result = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("class will load from parent context: " + name);
                }
                result = super.loadClass(name, resolve);
            }
        }
        return result;
    }

    private boolean isEligibleForOverriding(String name) {
        JAssert.checkNotNull(name, "name must not be null");
        return !this.isExcluded(name);
    }

    protected boolean isExcluded(String className) {
        JAssert.checkNotNull(className, "className must not be null");
        for (String packageName : this.excludedPackages) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (canCloseJar) {
            try {
                super.close();
            }
            catch (IOException ioe) {
                logger.warn("Invoke super close method fail", ioe);
            }
        } else {
            for (JarURLConnection conn : this.cachedJarFiles) {
                conn.getJarFile().close();
            }
            this.cachedJarFiles.clear();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("\r\n  excludedPackages: ");
        sb.append(this.excludedPackages);
        sb.append("\r\n");
        if (this.getParent() != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.getParent().toString());
        }
        return sb.toString();
    }

    @Override
    protected Object getClassLoadingLock(String className) {
        Object newLock;
        if (registerAsParallelCapable) {
            return super.getClassLoadingLock(className);
        }
        Object lock = this;
        if (this.parallelLockMap != null && (lock = this.parallelLockMap.putIfAbsent(className, newLock = new Object())) == null) {
            lock = newLock;
        }
        return lock;
    }

    static {
        try {
            URLClassLoader.class.getMethod("close", new Class[0]);
            canCloseJar = true;
            if (logger.isDebugEnabled()) {
                logger.debug("use URLClassLoader#close()");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
            registerAsParallelCapable = true;
            if (logger.isDebugEnabled()) {
                logger.debug("use ClassLoader#registerAsParallelCapable()");
            }
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

