/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util;

import com.jianggujin.modulelink.JAction;
import com.jianggujin.modulelink.JModule;
import com.jianggujin.modulelink.JModuleLinkException;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;

public class JModuleUtils {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JModuleUtils.class);

    public static void destroyQuietly(JModule module) {
        if (module != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Destroy module: " + module.getModuleConfig());
                }
                module.destroy();
            }
            catch (Exception e) {
                logger.error("Failed to destroy module " + module.getModuleConfig(), e);
            }
        }
    }

    public static Object doActionWithinModuleClassLoader(JAction action, Object in) {
        JAssert.checkNotNull(action, "action must not be null");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader moduleClassLoader = action.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(moduleClassLoader);
            Object object = action.execute(in);
            return object;
        }
        catch (Exception e) {
            throw new JModuleLinkException("doActionWithinModuleClassLoader has error, action=" + action, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

