/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util;

import com.jianggujin.modulelink.JModule;
import com.jianggujin.modulelink.JModuleConfig;
import com.jianggujin.modulelink.JModuleManager;
import com.jianggujin.modulelink.impl.JAbstractModuleManager;
import com.jianggujin.modulelink.util.JAbstractModuleRefreshScheduler;
import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.JStringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class JModuleWatch
implements Runnable {
    private final JLogFactory.JLog logger = JLogFactory.getLog(JAbstractModuleRefreshScheduler.class);
    private final JModuleManager moduleManager;
    private final String moduleRoot;
    private volatile boolean watching = false;

    public JModuleWatch(JAbstractModuleManager moduleManager, String moduleRoot) {
        JAssert.checkNotNull(moduleManager, "moduleManager must not be null.");
        JAssert.checkNotNull(moduleRoot, "moduleRoot must not be null.");
        this.moduleManager = moduleManager;
        this.moduleRoot = moduleRoot;
    }

    public synchronized void start() {
        if (!this.watching) {
            this.watching = true;
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        Path modulePath = Paths.get(this.moduleRoot, new String[0]);
        try {
            WatchService watcher = modulePath.getFileSystem().newWatchService();
            modulePath.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            while (this.watching) {
                WatchKey watckKey = watcher.take();
                List<WatchEvent<?>> events = watckKey.pollEvents();
                for (WatchEvent<?> event : events) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(event.context() + " change kind " + event.kind());
                    }
                    String moduleName = event.context().toString();
                    WatchEvent.Kind<?> kind = event.kind();
                    if (StandardWatchEventKinds.ENTRY_DELETE.equals(kind)) {
                        this.moduleManager.unload(moduleName);
                        continue;
                    }
                    if (!StandardWatchEventKinds.ENTRY_CREATE.equals(kind) && !StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) continue;
                    Set<JModuleConfig> queryConfigs = this.queryModuleConfigs(moduleName);
                    this.refreshModuleConfigs(moduleName, queryConfigs);
                }
                boolean valid = watckKey.reset();
                if (valid) continue;
                this.watching = false;
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("watch error", e);
        }
    }

    protected void refreshModuleConfigs(String name, Set<JModuleConfig> queryConfigs) {
        Set<String> queryVersions = this.queryModuleVersions(name, queryConfigs);
        if (queryVersions == null || queryVersions.isEmpty()) {
            if (this.moduleManager.has(name)) {
                try {
                    this.moduleManager.unload(name);
                }
                catch (Exception e) {
                    this.logger.error("unload module error.", e);
                }
            }
            return;
        }
        if (!this.moduleManager.has(name)) {
            for (JModuleConfig moduleConfig : queryConfigs) {
                try {
                    this.moduleManager.load(moduleConfig);
                }
                catch (Exception e) {
                    this.logger.error("load module error.", e);
                }
            }
            return;
        }
        for (JModuleConfig moduleConfig : queryConfigs) {
            if (this.moduleManager.has(name, moduleConfig.getVersion())) continue;
            try {
                this.moduleManager.load(moduleConfig);
            }
            catch (Exception e) {
                this.logger.error("load module error.", e);
            }
        }
        for (JModule module : this.moduleManager.getModules(name)) {
            if (queryVersions.contains(module.getModuleConfig().getVersion())) continue;
            try {
                this.moduleManager.unload(name, module.getModuleConfig().getVersion());
            }
            catch (Exception e) {
                this.logger.error("unload module error.", e);
            }
        }
    }

    protected Set<String> queryModuleVersions(String moduleName, Set<JModuleConfig> moduleConfigs) {
        if (moduleConfigs == null || moduleConfigs.isEmpty()) {
            return null;
        }
        HashSet<String> queryVersions = new HashSet<String>();
        Iterator<JModuleConfig> iterator = moduleConfigs.iterator();
        while (iterator.hasNext()) {
            JModuleConfig moduleConfig = iterator.next();
            if (!JStringUtils.equals(moduleName, moduleConfig.getName())) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("moduleName not match[" + moduleName + ", " + moduleConfig.getName() + "], ignore. " + moduleConfig);
                }
                iterator.remove();
                continue;
            }
            queryVersions.add(moduleConfig.getVersion());
        }
        return queryVersions;
    }

    public synchronized void destroy() {
        this.watching = false;
    }

    public boolean isWatching() {
        return this.watching;
    }

    public abstract Set<JModuleConfig> queryModuleConfigs(String var1);
}

