/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util;

import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.vfs.JVFS;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JResolverUtils {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JResolverUtils.class);
    private Set<Class<?>> matches = new HashSet();
    private Set<String> exclusions = new HashSet<String>();
    private ClassLoader classloader;

    public Set<String> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Set<String> exclusions) {
        JAssert.checkNotNull(exclusions, "exclusions must not be null");
        this.exclusions = exclusions;
    }

    public JResolverUtils withExclusions(Set<String> exclusions) {
        this.setExclusions(exclusions);
        return this;
    }

    public JResolverUtils addExclusions(Collection<? extends String> exclusions) {
        if (exclusions != null) {
            this.exclusions.addAll(exclusions);
        }
        return this;
    }

    public JResolverUtils addExclusion(String exclusion) {
        JAssert.checkNotNull(exclusion, "exclusion must not be null");
        this.exclusions.add(exclusion);
        return this;
    }

    public JResolverUtils removeExclusion(String exclusion) {
        this.exclusions.remove(exclusion);
        return this;
    }

    public Set<Class<?>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public JResolverUtils findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        JIsA test = new JIsA(parent);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public JResolverUtils findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        JAnnotatedWith test = new JAnnotatedWith(annotation);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public JResolverUtils find(JTest test, String packageName) {
        String path = this.getPackagePath(packageName);
        try {
            List<String> children = JVFS.getInstance().list(path);
            for (String child : children) {
                if (!child.endsWith(".class")) continue;
                this.addIfMatching(test, child);
            }
        }
        catch (IOException ioe) {
            logger.error("find error", ioe);
        }
        return this;
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected void addIfMatching(JTest test, String fqn) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            if (this.exclusions.contains(externalName)) {
                return;
            }
            ClassLoader loader = this.getClassLoader();
            Class<?> type = loader.loadClass(externalName);
            if (test.matches(type)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("find match class:" + type);
                }
                this.matches.add(type);
            }
        }
        catch (Throwable t) {
            logger.error("addIfMatching error", t);
        }
    }

    public static class JAnnotatedWith
    implements JTest {
        private Class<? extends Annotation> annotation;

        public JAnnotatedWith(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && type.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }

    public static class JIsA
    implements JTest {
        private Class<?> parent;

        public JIsA(Class<?> parentType) {
            this.parent = parentType;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    public static interface JTest {
        public boolean matches(Class<?> var1);
    }
}

