/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

public class JStringUtils {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static String reflectionToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        t.printStackTrace(writer);
        writer.close();
        return sw.toString();
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean notBlank(String str) {
        return !JStringUtils.isBlank(str);
    }

    public static boolean notBlank(String ... strings) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        for (String str : strings) {
            if (!JStringUtils.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static String toCamelCase(String stringWithUnderline) {
        if (stringWithUnderline.indexOf(95) == -1) {
            return stringWithUnderline;
        }
        stringWithUnderline = stringWithUnderline.toLowerCase();
        char[] fromArray = stringWithUnderline.toCharArray();
        char[] toArray = new char[fromArray.length];
        int j = 0;
        for (int i = 0; i < fromArray.length; ++i) {
            if (fromArray[i] == '_') {
                if (++i >= fromArray.length) continue;
                toArray[j++] = Character.toUpperCase(fromArray[i]);
                continue;
            }
            toArray[j++] = fromArray[i];
        }
        return new String(toArray, 0, j);
    }

    public static String join(String[] stringArray) {
        StringBuilder sb = new StringBuilder();
        for (String s : stringArray) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] stringArray, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(stringArray[i]);
        }
        return sb.toString();
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static String resolveDynamicPropnames(String text, Map<String, String> bindRes) {
        return JStringUtils.resolveDynamicPropnames(text, bindRes, "${", "}");
    }

    public static String resolveDynamicPropnames(String text, Map<String, String> bindRes, String prefix, String suffix) {
        if (text == null) {
            return text;
        }
        int startIndex = text.indexOf(prefix);
        if (startIndex == -1) {
            return text;
        }
        String tempStr = text;
        StringBuilder result = new StringBuilder(text.length() + 32);
        int prefixLength = prefix.length();
        while (startIndex != -1) {
            result.append(tempStr.substring(0, startIndex));
            int endIndex = tempStr.indexOf(suffix, startIndex + prefixLength);
            if (endIndex != -1) {
                String dName = tempStr.substring(startIndex + prefixLength, endIndex);
                try {
                    String obj;
                    String pValue = null;
                    if (bindRes != null && (obj = bindRes.get(dName)) != null) {
                        pValue = String.valueOf(obj);
                    }
                    if (pValue != null) {
                        result.append(JStringUtils.resolveDynamicPropnames(pValue, bindRes));
                    } else {
                        result.append(tempStr.substring(startIndex, endIndex + 1));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                tempStr = tempStr.substring(endIndex + suffix.length());
                startIndex = tempStr.indexOf(prefix);
                continue;
            }
            tempStr = tempStr.substring(startIndex);
            startIndex = -1;
        }
        result.append(tempStr);
        return result.toString();
    }

    public static String[] addStringToArray(String[] array, String str) {
        if (array == null || array.length == 0) {
            return new String[]{str};
        }
        String[] newArr = new String[array.length + 1];
        System.arraycopy(array, 0, newArr, 0, array.length);
        newArr[array.length] = str;
        return newArr;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static int indexOf(String str, char searchChar, int startPos) {
        if (JStringUtils.isEmpty(str)) {
            return -1;
        }
        return str.indexOf(searchChar, startPos);
    }

    public static String[] separateString(String str, String delimiter) {
        return JStringUtils.separateString(str, delimiter, false);
    }

    public static String[] separateString(String str, String delimiter, boolean trim) {
        if (str == null) {
            return null;
        }
        int count = str.length();
        if (count == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (JStringUtils.isEmpty(delimiter)) {
            delimiter = " \t\n\r\f";
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int begin = 0;
        boolean notMatch = false;
        if (delimiter.length() == 1) {
            char c = delimiter.charAt(0);
            while (i < count) {
                if (str.charAt(i) == c) {
                    if (notMatch) {
                        list.add(trim ? str.substring(begin, i).trim() : str.substring(begin, i));
                        notMatch = false;
                    }
                    begin = ++i;
                    continue;
                }
                notMatch = true;
                ++i;
            }
        } else {
            while (i < count) {
                if (delimiter.indexOf(str.charAt(i)) >= 0) {
                    if (notMatch) {
                        list.add(trim ? str.substring(begin, i).trim() : str.substring(begin, i));
                        notMatch = false;
                    }
                    begin = ++i;
                    continue;
                }
                notMatch = true;
                ++i;
            }
        }
        if (notMatch) {
            list.add(trim ? str.substring(begin, i).trim() : str.substring(begin, i));
        }
        return list.toArray(new String[list.size()]);
    }
}

