/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util;

import com.jianggujin.modulelink.util.JAssert;
import com.jianggujin.modulelink.util.JLogFactory;
import com.jianggujin.modulelink.util.JModuleClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public class JWebModuleClassLoader
extends JModuleClassLoader {
    private static final JLogFactory.JLog logger = JLogFactory.getLog(JWebModuleClassLoader.class);
    private URL classesUrl;

    public JWebModuleClassLoader(Set<URL> urls, File webRoot) {
        super(urls);
        JAssert.checkNotNull(webRoot, "webRoot must not be null.");
        File classesRoot = new File(webRoot, "WEB-INF/classes");
        try {
            this.classesUrl = classesRoot.toURI().toURL();
        }
        catch (MalformedURLException e) {
            logger.error("classes url error.", e);
        }
        this.addStandardWebUrl(classesRoot, new File(webRoot, "WEB-INF/lib"));
    }

    public JWebModuleClassLoader(Set<URL> urls, ClassLoader parent, File webRoot) {
        super(urls, parent);
        JAssert.checkNotNull(webRoot, "webRoot must not be null.");
        File classesRoot = new File(webRoot, "WEB-INF/classes");
        try {
            this.classesUrl = classesRoot.toURI().toURL();
        }
        catch (MalformedURLException e) {
            logger.error("classes url error.", e);
        }
        this.addStandardWebUrl(classesRoot, new File(webRoot, "WEB-INF/lib"));
    }

    private void addStandardWebUrl(File classesRoot, File libRoot) {
        File[] files;
        if (classesRoot.exists()) {
            try {
                this.addURL(classesRoot.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.error("add classes url error.", e);
            }
        }
        if (libRoot.exists() && (files = libRoot.listFiles()) != null) {
            for (File file : files) {
                try {
                    this.addURL(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.error("add lib url error.", e);
                }
            }
        }
    }

    @Override
    public URL getResource(String name) {
        if (name != null && name.length() == 0) {
            return this.classesUrl;
        }
        return super.getResource(name);
    }
}

