/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util.vfs;

import com.jianggujin.modulelink.util.vfs.JVFS;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JJBoss6VFS
extends JVFS {
    private static Boolean valid;

    protected static synchronized void initialize() {
        if (valid == null) {
            valid = Boolean.TRUE;
            VFS.VFS = JJBoss6VFS.checkNotNull(JJBoss6VFS.getClass("org.jboss.vfs.VFS"));
            VirtualFile.VirtualFile = JJBoss6VFS.checkNotNull(JJBoss6VFS.getClass("org.jboss.vfs.VirtualFile"));
            VFS.getChild = JJBoss6VFS.checkNotNull(JJBoss6VFS.getMethod(VFS.VFS, "getChild", URL.class));
            VirtualFile.getChildrenRecursively = JJBoss6VFS.checkNotNull(JJBoss6VFS.getMethod(VirtualFile.VirtualFile, "getChildrenRecursively", new Class[0]));
            VirtualFile.getPathNameRelativeTo = JJBoss6VFS.checkNotNull(JJBoss6VFS.getMethod(VirtualFile.VirtualFile, "getPathNameRelativeTo", VirtualFile.VirtualFile));
            JJBoss6VFS.checkReturnType(VFS.getChild, VirtualFile.VirtualFile);
            JJBoss6VFS.checkReturnType(VirtualFile.getChildrenRecursively, List.class);
            JJBoss6VFS.checkReturnType(VirtualFile.getPathNameRelativeTo, String.class);
        }
    }

    protected static <T> T checkNotNull(T object) {
        if (object == null) {
            JJBoss6VFS.setInvalid();
        }
        return object;
    }

    protected static void checkReturnType(Method method, Class<?> expected) {
        if (method != null && !expected.isAssignableFrom(method.getReturnType())) {
            JJBoss6VFS.setInvalid();
        }
    }

    protected static void setInvalid() {
        if (valid == Boolean.TRUE) {
            valid = Boolean.FALSE;
        }
    }

    @Override
    public boolean isValid() {
        return valid;
    }

    @Override
    public List<String> list(URL url, String path) throws IOException {
        VirtualFile directory = VFS.getChild(url);
        if (directory == null) {
            return Collections.emptyList();
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        List<VirtualFile> children = directory.getChildren();
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (VirtualFile vf : children) {
            names.add(path + vf.getPathNameRelativeTo(directory));
        }
        return names;
    }

    static {
        JJBoss6VFS.initialize();
    }

    static class VFS {
        static Class<?> VFS;
        static Method getChild;

        private VFS() {
        }

        static VirtualFile getChild(URL url) throws IOException {
            Object o = JVFS.invoke(getChild, VFS, url);
            return o == null ? null : new VirtualFile(o);
        }
    }

    static class VirtualFile {
        static Class<?> VirtualFile;
        static Method getPathNameRelativeTo;
        static Method getChildrenRecursively;
        Object virtualFile;

        VirtualFile(Object virtualFile) {
            this.virtualFile = virtualFile;
        }

        String getPathNameRelativeTo(VirtualFile parent) {
            try {
                return (String)JVFS.invoke(getPathNameRelativeTo, this.virtualFile, parent.virtualFile);
            }
            catch (IOException e) {
                return null;
            }
        }

        List<VirtualFile> getChildren() throws IOException {
            List objects = (List)JVFS.invoke(getChildrenRecursively, this.virtualFile, new Object[0]);
            ArrayList<VirtualFile> children = new ArrayList<VirtualFile>(objects.size());
            for (Object object : objects) {
                children.add(new VirtualFile(object));
            }
            return children;
        }
    }
}

