/*
 * Decompiled with CFR 0.152.
 */
package com.jianggujin.modulelink.util.vfs;

import com.jianggujin.modulelink.util.vfs.JDefaultVFS;
import com.jianggujin.modulelink.util.vfs.JJBoss6VFS;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class JVFS {
    public static final Class<?>[] IMPLEMENTATIONS = new Class[]{JJBoss6VFS.class, JDefaultVFS.class};
    public static final List<Class<? extends JVFS>> USER_IMPLEMENTATIONS = new ArrayList<Class<? extends JVFS>>();
    private static JVFS instance;

    public static JVFS getInstance() {
        if (instance != null) {
            return instance;
        }
        ArrayList impls = new ArrayList();
        impls.addAll(USER_IMPLEMENTATIONS);
        impls.addAll(Arrays.asList(IMPLEMENTATIONS));
        JVFS vfs = null;
        int i = 0;
        while (vfs == null || !vfs.isValid()) {
            Class impl = (Class)impls.get(i);
            try {
                vfs = (JVFS)impl.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            ++i;
        }
        instance = vfs;
        return instance;
    }

    public static void addImplClass(Class<? extends JVFS> clazz) {
        if (clazz != null) {
            USER_IMPLEMENTATIONS.add(clazz);
        }
    }

    protected static Class<?> getClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected static <T> T invoke(Method method, Object object, Object ... parameters) throws IOException, RuntimeException {
        try {
            return (T)method.invoke(object, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            throw new RuntimeException(e);
        }
    }

    protected static List<URL> getResources(String path) throws IOException {
        return Collections.list(Thread.currentThread().getContextClassLoader().getResources(path));
    }

    public abstract boolean isValid();

    protected abstract List<String> list(URL var1, String var2) throws IOException;

    public List<String> list(String path) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        for (URL url : JVFS.getResources(path)) {
            names.addAll(this.list(url, path));
        }
        return names;
    }
}

