/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.adt;

import com.jnape.palatable.lambda.adt.coproduct.CoProduct2;
import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.lambda.functions.specialized.checked.CheckedSupplier;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Bifunctor;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Either<L, R>
implements CoProduct2<L, R, Either<L, R>>,
Applicative<R, Either<L, ?>>,
Traversable<R, Either<L, ?>>,
Bifunctor<L, R, Either> {
    private Either() {
    }

    public final R or(R defaultValue) {
        return (R)this.recover(l -> defaultValue);
    }

    public final R recover(Function<? super L, ? extends R> recoveryFn) {
        return this.match((Function)recoveryFn, Id.id());
    }

    public final L forfeit(Function<? super R, ? extends L> forfeitFn) {
        return this.match(Id.id(), (Function)forfeitFn);
    }

    public final <T extends Throwable> R orThrow(Function<? super L, ? extends T> throwableFn) throws T {
        return (R)this.match(l -> {
            throw (Throwable)throwableFn.apply((Object)l);
        }, Id.id());
    }

    public final Either<L, R> filter(Function<? super R, Boolean> pred, Supplier<L> leftSupplier) {
        return this.flatMap(r -> (Boolean)pred.apply((Object)r) != false ? Either.right(r) : Either.left(leftSupplier.get()));
    }

    public final <R2> Either<L, R2> flatMap(Function<? super R, ? extends Either<L, R2>> rightFn) {
        return this.flatMap(Either::left, rightFn);
    }

    public final <L2, R2> Either<L2, R2> flatMap(Function<? super L, ? extends Either<L2, R2>> leftFn, Function<? super R, ? extends Either<L2, R2>> rightFn) {
        return this.match((Function)leftFn, (Function)rightFn);
    }

    public final Either<R, L> invert() {
        return this.flatMap(Either::right, Either::left);
    }

    @SafeVarargs
    public final Either<L, R> merge(BiFunction<? super L, ? super L, ? extends L> leftFn, BiFunction<? super R, ? super R, ? extends R> rightFn, Either<L, R> ... others) {
        return FoldLeft.foldLeft((x, y) -> x.match((Function)l1 -> y.match((Function)l2 -> Either.left(leftFn.apply((Object)l1, (Object)l2)), (Function)r -> Either.left(l1)), (Function)r1 -> y.match((Function)Either::left, (Function)r2 -> Either.right(rightFn.apply((Object)r1, (Object)r2)))), this, Arrays.asList(others));
    }

    public Either<L, R> peek(Consumer<R> rightConsumer) {
        return this.peek(l -> {}, rightConsumer);
    }

    public Either<L, R> peek(Consumer<L> leftConsumer, Consumer<R> rightConsumer) {
        return this.flatMap(l -> {
            leftConsumer.accept(l);
            return this;
        }, r -> {
            rightConsumer.accept(r);
            return this;
        });
    }

    @Override
    public abstract <V> V match(Function<? super L, ? extends V> var1, Function<? super R, ? extends V> var2);

    @Override
    public final <R2> Either<L, R2> fmap(Function<? super R, ? extends R2> fn) {
        return (Either)Applicative.super.fmap(fn);
    }

    public final <L2> Either<L2, R> biMapL(Function<? super L, ? extends L2> fn) {
        return (Either)Bifunctor.super.biMapL(fn);
    }

    public final <R2> Either<L, R2> biMapR(Function<? super R, ? extends R2> fn) {
        return (Either)Bifunctor.super.biMapR(fn);
    }

    public final <L2, R2> Either<L2, R2> biMap(Function<? super L, ? extends L2> leftFn, Function<? super R, ? extends R2> rightFn) {
        return this.match((Function)l -> Either.left(leftFn.apply((Object)l)), (Function)r -> Either.right(rightFn.apply((Object)r)));
    }

    @Override
    public <R2> Either<L, R2> pure(R2 r2) {
        return Either.right(r2);
    }

    @Override
    public <R2> Either<L, R2> zip(Applicative<Function<? super R, ? extends R2>, Either<L, ?>> appFn) {
        return ((Either)appFn.coerce()).flatMap(function -> this.biMapR((Function)function));
    }

    @Override
    public <R2> Either<L, R2> discardL(Applicative<R2, Either<L, ?>> appB) {
        return (Either)Applicative.super.discardL(appB).coerce();
    }

    @Override
    public <R2> Either<L, R> discardR(Applicative<R2, Either<L, ?>> appB) {
        return (Either)Applicative.super.discardR(appB).coerce();
    }

    @Override
    public <R2, App extends Applicative> Applicative<Either<L, R2>, App> traverse(Function<? super R, ? extends Applicative<R2, App>> fn, Function<? super Traversable<R2, Either<L, ?>>, ? extends Applicative<? extends Traversable<R2, Either<L, ?>>, App>> pure) {
        return this.match((Function)l -> ((Applicative)pure.apply(Either.left(l))).fmap((T x) -> (Either)x), (Function)r -> ((Applicative)fn.apply((Object)r)).fmap(Either::right));
    }

    public Optional<R> toOptional() {
        return this.match((Function)__ -> Optional.empty(), (Function)Optional::ofNullable);
    }

    public static <L, R> Either<L, R> fromOptional(Optional<R> optional, Supplier<L> leftFn) {
        return optional.map(Either::right).orElseGet(() -> Either.left(leftFn.get()));
    }

    public static <E extends Exception, L, R> Either<L, R> trying(CheckedSupplier<E, ? extends R> supplier, Function<? super E, ? extends L> leftFn) {
        try {
            return Either.right(supplier.get());
        }
        catch (Exception e) {
            return Either.left(leftFn.apply(e));
        }
    }

    public static <E extends Exception, R> Either<E, R> trying(CheckedSupplier<E, R> supplier) {
        return Either.trying(supplier, Id.id());
    }

    public static <L, R> Either<L, R> left(L l) {
        return new Left(l);
    }

    public static <L, R> Either<L, R> right(R r) {
        return new Right(r);
    }

    private static final class Right<L, R>
    extends Either<L, R> {
        private final R r;

        private Right(R r) {
            this.r = r;
        }

        @Override
        public <V> V match(Function<? super L, ? extends V> leftFn, Function<? super R, ? extends V> rightFn) {
            return rightFn.apply(this.r);
        }

        public boolean equals(Object other) {
            return other instanceof Right && Objects.equals(this.r, ((Right)other).r);
        }

        public int hashCode() {
            return Objects.hash(this.r);
        }

        public String toString() {
            return "Right{r=" + this.r + '}';
        }
    }

    private static final class Left<L, R>
    extends Either<L, R> {
        private final L l;

        private Left(L l) {
            this.l = l;
        }

        @Override
        public <V> V match(Function<? super L, ? extends V> leftFn, Function<? super R, ? extends V> rightFn) {
            return leftFn.apply(this.l);
        }

        public boolean equals(Object other) {
            return other instanceof Left && Objects.equals(this.l, ((Left)other).l);
        }

        public int hashCode() {
            return Objects.hash(this.l);
        }

        public String toString() {
            return "Left{l=" + this.l + '}';
        }
    }
}

