/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.functions.builtin.fn2;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.Fn2;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;

public final class ReduceLeft<A>
implements Fn2<BiFunction<? super A, ? super A, ? extends A>, Iterable<A>, Optional<A>> {
    private static final ReduceLeft INSTANCE = new ReduceLeft();

    private ReduceLeft() {
    }

    @Override
    public Optional<A> apply(BiFunction<? super A, ? super A, ? extends A> fn, Iterable<A> as) {
        Iterator iterator = as.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(FoldLeft.foldLeft(fn, iterator.next(), () -> iterator));
    }

    public static <A> ReduceLeft<A> reduceLeft() {
        return INSTANCE;
    }

    public static <A> Fn1<Iterable<A>, Optional<A>> reduceLeft(BiFunction<? super A, ? super A, ? extends A> fn) {
        return ReduceLeft.reduceLeft().apply(fn);
    }

    public static <A> Optional<A> reduceLeft(BiFunction<? super A, ? super A, ? extends A> fn, Iterable<A> as) {
        return ReduceLeft.reduceLeft(fn).apply(as);
    }
}

