/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class ConcatenatingIterator<A>
implements Iterator<A> {
    private final Supplier<Iterator<A>> xsSupplier = xs::iterator;
    private final Supplier<Iterator<A>> ysSupplier = ys::iterator;
    private final AtomicReference<Iterator<A>> xsRef = new AtomicReference();
    private final AtomicReference<Iterator<A>> ysRef = new AtomicReference();
    private boolean iteratedXs = false;

    public ConcatenatingIterator(Iterable<A> xs, Iterable<A> ys) {
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext(this.xsRef, this.xsSupplier)) {
            return true;
        }
        this.iteratedXs = true;
        return this.hasNext(this.ysRef, this.ysSupplier);
    }

    private boolean hasNext(AtomicReference<Iterator<A>> ref, Supplier<Iterator<A>> supplier) {
        Iterator<A> as = ref.updateAndGet(it -> it == null ? (Iterator)supplier.get() : it);
        while (as instanceof ConcatenatingIterator && ((ConcatenatingIterator)as).iteratedXs) {
            as = ref.updateAndGet(it -> ((ConcatenatingIterator)it).ysRef.get());
        }
        return as.hasNext();
    }

    @Override
    public A next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return !this.iteratedXs ? this.xsRef.get().next() : this.ysRef.get().next();
    }
}

