/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public final class ConsingIterator<A>
implements Iterator<A> {
    private final A head;
    private final Supplier<Iterator<A>> asSupplier;
    private Iterator<A> asIterator;
    private boolean iteratedHead;

    public ConsingIterator(A head, Iterable<A> as) {
        this.head = head;
        this.asSupplier = as::iterator;
        this.iteratedHead = false;
    }

    @Override
    public boolean hasNext() {
        if (!this.iteratedHead) {
            return true;
        }
        if (this.asIterator == null) {
            this.asIterator = this.asSupplier.get();
        }
        return this.asIterator.hasNext();
    }

    @Override
    public A next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.iteratedHead) {
            this.iteratedHead = true;
            return this.head;
        }
        while (this.asIterator instanceof ConsingIterator && ((ConsingIterator)this.asIterator).iteratedHead) {
            ConsingIterator cons = (ConsingIterator)this.asIterator;
            if (!cons.iteratedHead || cons.asIterator == null) continue;
            this.asIterator = cons.asIterator;
        }
        return this.asIterator.next();
    }
}

