/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iterators;

import com.jnape.palatable.lambda.iterators.ImmutableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DroppingIterator<A>
extends ImmutableIterator<A> {
    private final Integer n;
    private final Iterator<A> asIterator;
    private boolean dropped;

    public DroppingIterator(Integer n, Iterator<A> asIterator) {
        this.n = n;
        this.asIterator = asIterator;
        this.dropped = false;
    }

    @Override
    public boolean hasNext() {
        this.dropIfNecessary();
        return this.asIterator.hasNext();
    }

    @Override
    public A next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.asIterator.next();
    }

    private void dropIfNecessary() {
        if (!this.dropped) {
            int i = 0;
            while (i++ < this.n && this.asIterator.hasNext()) {
                this.asIterator.next();
            }
            this.dropped = true;
        }
    }
}

