/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.lens;

import com.jnape.palatable.lambda.functions.Fn2;
import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Functor;
import com.jnape.palatable.lambda.functor.Profunctor;
import com.jnape.palatable.lambda.lens.functions.Over;
import com.jnape.palatable.lambda.lens.functions.Set;
import com.jnape.palatable.lambda.lens.functions.View;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface Lens<S, T, A, B>
extends Applicative<T, Lens<S, ?, A, B>>,
Profunctor<S, T, Lens<?, ?, A, B>> {
    public <F extends Functor, FT extends Functor<T, F>, FB extends Functor<B, F>> FT apply(Function<? super A, ? extends FB> var1, S var2);

    default public <F extends Functor, FT extends Functor<T, F>, FB extends Functor<B, F>> Fixed<S, T, A, B, F, FT, FB> fix() {
        return this::apply;
    }

    default public <U> Lens<S, U, A, B> fmap(Function<? super T, ? extends U> fn) {
        return (Lens)Applicative.super.fmap(fn);
    }

    default public <U> Lens<S, U, A, B> pure(U u) {
        return Lens.lens(View.view(this), (s, b) -> u);
    }

    default public <U> Lens<S, U, A, B> zip(Applicative<Function<? super T, ? extends U>, Lens<S, ?, A, B>> appFn) {
        return Lens.lens(View.view(this), (s, b) -> ((Function)Set.set((Lens)appFn.coerce(), b, s)).apply(Set.set(this, b, s)));
    }

    default public <U> Lens<S, U, A, B> discardL(Applicative<U, Lens<S, ?, A, B>> appB) {
        return (Lens)Applicative.super.discardL(appB).coerce();
    }

    default public <U> Lens<S, T, A, B> discardR(Applicative<U, Lens<S, ?, A, B>> appB) {
        return (Lens)Applicative.super.discardR(appB).coerce();
    }

    default public <R, U> Lens<R, U, A, B> diMap(Function<R, S> lFn, Function<T, U> rFn) {
        return this.mapS(lFn).mapT(rFn);
    }

    default public <R> Lens<R, T, A, B> mapS(Function<? super R, ? extends S> fn) {
        return this.compose(Lens.lens(fn, (r, t) -> t));
    }

    default public <U> Lens<S, U, A, B> mapT(Function<? super T, ? extends U> fn) {
        return this.fmap((Function)fn);
    }

    default public <C> Lens<S, T, C, B> mapA(Function<? super A, ? extends C> fn) {
        return this.andThen(Lens.lens(fn, (a, b) -> b));
    }

    default public <Z> Lens<S, T, A, Z> mapB(Function<? super Z, ? extends B> fn) {
        return this.andThen(Lens.lens(Id.id(), (a, z) -> fn.apply((Object)z)));
    }

    default public <C, D> Lens<S, T, C, D> andThen(Lens<A, B, C, D> f) {
        return f.compose(this);
    }

    default public <Q, R> Lens<Q, R, A, B> compose(Lens<Q, R, S, T> g) {
        return Lens.lens(View.view(g).fmap((Function)View.view(this)), (q, b) -> Over.over(g, Set.set(this, b), q));
    }

    public static <S, T, A, B> Lens<S, T, A, B> lens(final Function<? super S, ? extends A> getter, final BiFunction<? super S, ? super B, ? extends T> setter) {
        return new Lens<S, T, A, B>(){

            @Override
            public <F extends Functor, FT extends Functor<T, F>, FB extends Functor<B, F>> FT apply(Function<? super A, ? extends FB> fn, S s) {
                return (FT)((Functor)fn.apply(getter.apply(s))).fmap((? super A b) -> setter.apply(s, b));
            }
        };
    }

    public static <S, A> Simple<S, A> simpleLens(Function<? super S, ? extends A> getter, BiFunction<? super S, ? super A, ? extends S> setter) {
        return Lens.lens(getter, setter)::apply;
    }

    @FunctionalInterface
    public static interface Fixed<S, T, A, B, F extends Functor, FT extends Functor<T, F>, FB extends Functor<B, F>>
    extends Fn2<Function<? super A, ? extends FB>, S, FT> {
    }

    @FunctionalInterface
    public static interface Simple<S, A>
    extends Lens<S, S, A, A> {
        default public <F extends Functor, FS extends Functor<S, F>, FA extends Functor<A, F>> Fixed<S, A, F, FS, FA> fix() {
            return this::apply;
        }

        default public <Q> Simple<Q, A> compose(Simple<Q, S> g) {
            return Lens.super.compose(g)::apply;
        }

        default public <B> Simple<S, B> andThen(Simple<A, B> f) {
            return f.compose(this);
        }

        @FunctionalInterface
        public static interface Fixed<S, A, F extends Functor, FS extends Functor<S, F>, FA extends Functor<A, F>>
        extends com.jnape.palatable.lambda.lens.Lens$Fixed<S, S, A, A, F, FS, FA> {
        }
    }
}

