/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.lens.lenses;

import com.jnape.palatable.lambda.lens.Lens;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public final class CollectionLens {
    private CollectionLens() {
    }

    public static <X, CX extends Collection<X>> Lens.Simple<CX, CX> asCopy(Function<? super CX, ? extends CX> copyFn) {
        return Lens.simpleLens(copyFn, (__, copy) -> copy);
    }

    public static <X, CX extends Collection<X>> Lens.Simple<CX, Set<X>> asSet() {
        return Lens.simpleLens(HashSet::new, (xsL, xsS) -> {
            xsL.retainAll((Collection<?>)xsS);
            return xsL;
        });
    }

    public static <X, CX extends Collection<X>> Lens.Simple<CX, Stream<X>> asStream() {
        return Lens.simpleLens(Collection::stream, (xsL, xsS) -> {
            xsL.clear();
            xsS.forEach(xsL::add);
            return xsL;
        });
    }
}

