/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.lens.lenses;

import com.jnape.palatable.lambda.lens.Lens;
import com.jnape.palatable.lambda.lens.lenses.OptionalLens;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class ListLens {
    private ListLens() {
    }

    public static <X> Lens.Simple<List<X>, List<X>> asCopy() {
        return Lens.simpleLens(ArrayList::new, (xs, ys) -> ys);
    }

    public static <X> Lens<List<X>, List<X>, Optional<X>, X> elementAt(int index) {
        return Lens.lens(xs -> Optional.ofNullable(xs.size() > index ? (Object)xs.get(index) : null), (xs, x) -> {
            if (xs.size() > index) {
                xs.set(index, x);
            }
            return xs;
        });
    }

    public static <X> Lens.Simple<List<X>, X> elementAt(int index, X defaultValue) {
        return OptionalLens.unLiftA(ListLens.elementAt(index), defaultValue)::apply;
    }
}

