/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.lens.lenses;

import com.jnape.palatable.lambda.functions.builtin.fn2.Eq;
import com.jnape.palatable.lambda.functions.builtin.fn2.Filter;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.functions.builtin.fn2.ToCollection;
import com.jnape.palatable.lambda.lens.Lens;
import com.jnape.palatable.lambda.lens.functions.View;
import com.jnape.palatable.lambda.lens.lenses.OptionalLens;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class MapLens {
    private MapLens() {
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, java.util.Map<K, V>> asCopy() {
        return Lens.simpleLens(HashMap::new, (__, copy) -> copy);
    }

    public static <K, V> Lens<java.util.Map<K, V>, java.util.Map<K, V>, Optional<V>, V> valueAt(K k) {
        return Lens.lens(m -> Optional.ofNullable(m.get(k)), (m, v) -> {
            m.put(k, v);
            return m;
        });
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, V> valueAt(K k, V defaultValue) {
        return OptionalLens.unLiftA(MapLens.valueAt(k), defaultValue)::apply;
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, Set<K>> keys() {
        return Lens.simpleLens(java.util.Map::keySet, (m, ks) -> {
            Set keys = m.keySet();
            keys.retainAll((Collection<?>)ks);
            ks.removeAll(keys);
            ks.forEach(k -> m.put(k, null));
            return m;
        });
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, Collection<V>> values() {
        return Lens.simpleLens(java.util.Map::values, (m, vs) -> {
            HashSet valueSet = new HashSet(vs);
            Set matchingKeys = m.entrySet().stream().filter(kv -> valueSet.contains(kv.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            m.keySet().retainAll(matchingKeys);
            return m;
        });
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, java.util.Map<V, K>> inverted() {
        return Lens.simpleLens(m -> {
            HashMap inverted = new HashMap();
            m.forEach((key, value) -> inverted.put(value, key));
            return inverted;
        }, (m, im) -> {
            m.clear();
            m.putAll((java.util.Map)View.view(MapLens.inverted(), im));
            return m;
        });
    }

    public static <K, V, V2> Lens.Simple<java.util.Map<K, V>, java.util.Map<K, V2>> mappingValues(Function<? super V, ? extends V2> fn) {
        return Lens.simpleLens(m -> m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> fn.apply((Object)kv.getValue()))), (s, b) -> {
            Set retainKeys = (Set)Filter.filter(kv -> Eq.eq(fn.apply((Object)kv.getValue()), b.get(kv.getKey()))).andThen(Map.map(Map.Entry::getKey)).andThen((Function)ToCollection.toCollection(HashSet::new)).apply(s.entrySet());
            HashMap copy = new HashMap(s);
            copy.keySet().retainAll(retainKeys);
            return copy;
        });
    }
}

