/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.lens.lenses;

import com.jnape.palatable.lambda.lens.Lens;
import java.util.Optional;

public final class OptionalLens {
    private OptionalLens() {
    }

    public static <V> Lens.Simple<V, Optional<V>> asOptional() {
        return Lens.simpleLens(Optional::ofNullable, (v, optV) -> optV.orElse(v));
    }

    public static <S, T, A, B> Lens<Optional<S>, T, A, B> liftS(Lens<S, T, A, B> lens, S defaultS) {
        return lens.mapS(optS -> optS.orElse(defaultS));
    }

    public static <S, T, A, B> Lens<S, Optional<T>, A, B> liftT(Lens<S, T, A, B> lens) {
        return lens.mapT(Optional::ofNullable);
    }

    public static <S, T, A, B> Lens<S, T, Optional<A>, B> liftA(Lens<S, T, A, B> lens) {
        return lens.mapA(Optional::ofNullable);
    }

    public static <S, T, A, B> Lens<S, T, A, Optional<B>> liftB(Lens<S, T, A, B> lens, B defaultB) {
        return lens.mapB(optB -> optB.orElse(defaultB));
    }

    public static <S, T, A, B> Lens<S, T, A, B> unLiftS(Lens<Optional<S>, T, A, B> lens) {
        return lens.mapS(Optional::ofNullable);
    }

    public static <S, T, A, B> Lens<S, T, A, B> unLiftT(Lens<S, Optional<T>, A, B> lens, T defaultT) {
        return lens.mapT(optT -> optT.orElse(defaultT));
    }

    public static <S, T, A, B> Lens<S, T, A, B> unLiftA(Lens<S, T, Optional<A>, B> lens, A defaultA) {
        return lens.mapA(optA -> optA.orElse(defaultA));
    }

    public static <S, T, A, B> Lens<S, T, A, B> unLiftB(Lens<S, T, A, Optional<B>> lens) {
        return lens.mapB(Optional::ofNullable);
    }
}

