/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.traversable;

import com.jnape.palatable.lambda.functions.builtin.fn2.Cons;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldRight;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;

public final class TraversableIterable<A>
implements Traversable<A, TraversableIterable> {
    private final Iterable<A> as;

    private TraversableIterable(Iterable<? extends A> as) {
        this.as = as;
    }

    public Iterable<A> unwrap() {
        return this.as;
    }

    public <B> TraversableIterable<B> fmap(Function<? super A, ? extends B> fn) {
        return TraversableIterable.wrap(Map.map(fn, this.as));
    }

    @Override
    public <B, App extends Applicative> Applicative<TraversableIterable<B>, App> traverse(Function<? super A, ? extends Applicative<B, App>> fn, Function<? super Traversable<B, TraversableIterable>, ? extends Applicative<? extends Traversable<B, TraversableIterable>, App>> pure) {
        return (Applicative)FoldRight.foldRight((a, appTrav) -> appTrav.zip(((Applicative)fn.apply((Object)a)).fmap((T b) -> bs -> TraversableIterable.wrap(Cons.cons(b, bs.unwrap())))), pure.apply(TraversableIterable.empty()).fmap((T ti) -> (TraversableIterable)ti), this.as);
    }

    public boolean equals(Object other) {
        if (other instanceof TraversableIterable) {
            Iterator<A> xs = this.as.iterator();
            Iterator<A> ys = ((TraversableIterable)other).as.iterator();
            while (xs.hasNext() && ys.hasNext()) {
                if (Objects.equals(xs.next(), ys.next())) continue;
                return false;
            }
            return xs.hasNext() == ys.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.as);
    }

    public static <A> TraversableIterable<A> wrap(Iterable<? extends A> as) {
        return new TraversableIterable<A>(as);
    }

    public static <A> TraversableIterable<A> empty() {
        return TraversableIterable.wrap(Collections.emptyList());
    }
}

