/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.adt;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.adt.Try;
import com.jnape.palatable.lambda.adt.Unit;
import com.jnape.palatable.lambda.adt.coproduct.CoProduct2;
import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functions.builtin.fn2.Peek;
import com.jnape.palatable.lambda.functions.builtin.fn2.Peek2;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.lambda.functions.specialized.checked.CheckedRunnable;
import com.jnape.palatable.lambda.functions.specialized.checked.CheckedSupplier;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Bifunctor;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Either<L, R>
implements CoProduct2<L, R, Either<L, R>>,
Monad<R, Either<L, ?>>,
Traversable<R, Either<L, ?>>,
Bifunctor<L, R, Either> {
    private Either() {
    }

    public final R or(R defaultValue) {
        return (R)this.recover(l -> defaultValue);
    }

    public final R recover(Function<? super L, ? extends R> recoveryFn) {
        return this.match((Function)recoveryFn, Id.id());
    }

    public final L forfeit(Function<? super R, ? extends L> forfeitFn) {
        return this.match(Id.id(), (Function)forfeitFn);
    }

    public final <T extends Throwable> R orThrow(Function<? super L, ? extends T> throwableFn) throws T {
        return (R)this.match(l -> {
            throw (Throwable)throwableFn.apply((Object)l);
        }, Id.id());
    }

    public final Either<L, R> filter(Function<? super R, Boolean> pred, Supplier<L> leftSupplier) {
        return this.filter(pred, (? super R __) -> leftSupplier.get());
    }

    public final Either<L, R> filter(Function<? super R, Boolean> pred, Function<? super R, ? extends L> leftFn) {
        return this.flatMap((T r) -> (Boolean)pred.apply((Object)r) != false ? Either.right(r) : Either.left(leftFn.apply((Object)r)));
    }

    @Override
    public <R2> Either<L, R2> flatMap(Function<? super R, ? extends Monad<R2, Either<L, ?>>> rightFn) {
        return this.flatMap(Either::left, rightFn.andThen(Applicative::coerce));
    }

    public final <L2, R2> Either<L2, R2> flatMap(Function<? super L, ? extends Either<L2, R2>> leftFn, Function<? super R, ? extends Either<L2, R2>> rightFn) {
        return this.match((Function)leftFn, (Function)rightFn);
    }

    public final Either<R, L> invert() {
        return this.flatMap(Either::right, Either::left);
    }

    @SafeVarargs
    public final Either<L, R> merge(BiFunction<? super L, ? super L, ? extends L> leftFn, BiFunction<? super R, ? super R, ? extends R> rightFn, Either<L, R> ... others) {
        return FoldLeft.foldLeft((x, y) -> x.match((Function)l1 -> y.match((Function)l2 -> Either.left(leftFn.apply((Object)l1, (Object)l2)), (Function)r -> Either.left(l1)), (Function)r1 -> y.match((Function)Either::left, (Function)r2 -> Either.right(rightFn.apply((Object)r1, (Object)r2)))), this, Arrays.asList(others));
    }

    public Either<L, R> peek(Consumer<R> rightConsumer) {
        return Peek.peek(rightConsumer, this);
    }

    public Either<L, R> peek(Consumer<L> leftConsumer, Consumer<R> rightConsumer) {
        return Peek2.peek2(leftConsumer, rightConsumer, this);
    }

    @Override
    public abstract <V> V match(Function<? super L, ? extends V> var1, Function<? super R, ? extends V> var2);

    @Override
    public final <R2> Either<L, R2> fmap(Function<? super R, ? extends R2> fn) {
        return (Either)Monad.super.fmap(fn).coerce();
    }

    public final <L2> Either<L2, R> biMapL(Function<? super L, ? extends L2> fn) {
        return (Either)Bifunctor.super.biMapL(fn);
    }

    public final <R2> Either<L, R2> biMapR(Function<? super R, ? extends R2> fn) {
        return (Either)Bifunctor.super.biMapR(fn);
    }

    public final <L2, R2> Either<L2, R2> biMap(Function<? super L, ? extends L2> leftFn, Function<? super R, ? extends R2> rightFn) {
        return this.match((Function)l -> Either.left(leftFn.apply((Object)l)), (Function)r -> Either.right(rightFn.apply((Object)r)));
    }

    @Override
    public final <R2> Either<L, R2> pure(R2 r2) {
        return Either.right(r2);
    }

    @Override
    public final <R2> Either<L, R2> zip(Applicative<Function<? super R, ? extends R2>, Either<L, ?>> appFn) {
        return ((Either)appFn.coerce()).flatMap((T function) -> this.biMapR((Function)function));
    }

    @Override
    public final <R2> Either<L, R2> discardL(Applicative<R2, Either<L, ?>> appB) {
        return (Either)Monad.super.discardL(appB).coerce();
    }

    @Override
    public final <R2> Either<L, R> discardR(Applicative<R2, Either<L, ?>> appB) {
        return (Either)Monad.super.discardR(appB).coerce();
    }

    @Override
    public final <R2, App extends Applicative, TravB extends Traversable<R2, Either<L, ?>>, AppB extends Applicative<R2, App>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Function<? super R, ? extends AppB> fn, Function<? super TravB, ? extends AppTrav> pure) {
        return (AppTrav)this.match((Function)l -> (Applicative)pure.apply((Object)Either.left(l)), (Function)r -> ((Applicative)fn.apply((Object)r)).fmap(Either::right));
    }

    public final Maybe<R> toMaybe() {
        return this.projectB();
    }

    public static <L, R> Either<L, R> fromMaybe(Maybe<R> maybe, Supplier<L> leftFn) {
        return ((Maybe)maybe.fmap(Either::right)).orElseGet(() -> Either.left(leftFn.get()));
    }

    public static <E extends Exception, L, R> Either<L, R> trying(CheckedSupplier<E, ? extends R> supplier, Function<? super E, ? extends L> leftFn) {
        return Try.trying(supplier::get).toEither(leftFn);
    }

    public static <E extends Exception, R> Either<E, R> trying(CheckedSupplier<E, R> supplier) {
        return Either.trying(supplier, Id.id());
    }

    public static <E extends Exception, L> Either<L, Unit> trying(CheckedRunnable<E> runnable, Function<? super E, ? extends L> leftFn) {
        return Try.trying(runnable).toEither(leftFn);
    }

    public static <E extends Exception> Either<E, Unit> trying(CheckedRunnable<E> runnable) {
        return Either.trying(runnable, Id.id());
    }

    public static <L, R> Either<L, R> left(L l) {
        return new Left(l);
    }

    public static <L, R> Either<L, R> right(R r) {
        return new Right(r);
    }

    private static final class Right<L, R>
    extends Either<L, R> {
        private final R r;

        private Right(R r) {
            this.r = r;
        }

        @Override
        public <V> V match(Function<? super L, ? extends V> leftFn, Function<? super R, ? extends V> rightFn) {
            return rightFn.apply(this.r);
        }

        public boolean equals(Object other) {
            return other instanceof Right && Objects.equals(this.r, ((Right)other).r);
        }

        public int hashCode() {
            return Objects.hash(this.r);
        }

        public String toString() {
            return "Right{r=" + this.r + '}';
        }
    }

    private static final class Left<L, R>
    extends Either<L, R> {
        private final L l;

        private Left(L l) {
            this.l = l;
        }

        @Override
        public <V> V match(Function<? super L, ? extends V> leftFn, Function<? super R, ? extends V> rightFn) {
            return leftFn.apply(this.l);
        }

        public boolean equals(Object other) {
            return other instanceof Left && Objects.equals(this.l, ((Left)other).l);
        }

        public int hashCode() {
            return Objects.hash(this.l);
        }

        public String toString() {
            return "Left{l=" + this.l + '}';
        }
    }
}

