/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.adt;

import com.jnape.palatable.lambda.adt.Either;
import com.jnape.palatable.lambda.functions.builtin.fn2.Peek;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Maybe<A>
implements Monad<A, Maybe>,
Traversable<A, Maybe> {
    private Maybe() {
    }

    public abstract A orElseGet(Supplier<A> var1);

    public final A orElse(A other) {
        return (A)this.orElseGet(() -> other);
    }

    public final <E extends Throwable> A orElseThrow(Supplier<E> throwableSupplier) throws E {
        return this.orElseGet(() -> {
            throw (Throwable)throwableSupplier.get();
        });
    }

    public final Maybe<A> filter(Function<? super A, ? extends Boolean> predicate) {
        return this.flatMap((T a) -> (Boolean)predicate.apply((Object)a) != false ? Maybe.just(a) : Maybe.nothing());
    }

    public final <L> Either<L, A> toEither(Supplier<L> lSupplier) {
        return ((Maybe)this.fmap(Either::right)).orElseGet(() -> Either.left(lSupplier.get()));
    }

    public final Optional<A> toOptional() {
        return ((Maybe)this.fmap(Optional::of)).orElseGet(Optional::empty);
    }

    public final <B> Maybe<B> pure(B b) {
        return Maybe.just(b);
    }

    public final <B> Maybe<B> fmap(Function<? super A, ? extends B> fn) {
        return (Maybe)Monad.super.fmap((Function)fn).coerce();
    }

    public final <B> Maybe<B> zip(Applicative<Function<? super A, ? extends B>, Maybe> appFn) {
        return (Maybe)Monad.super.zip(appFn).coerce();
    }

    public final <B> Maybe<B> discardL(Applicative<B, Maybe> appB) {
        return (Maybe)Monad.super.discardL(appB).coerce();
    }

    public final <B> Maybe<A> discardR(Applicative<B, Maybe> appB) {
        return (Maybe)Monad.super.discardR(appB).coerce();
    }

    public abstract <B> Maybe<B> flatMap(Function<? super A, ? extends Monad<B, Maybe>> var1);

    public final Maybe<A> peek(Consumer<A> consumer) {
        return Peek.peek(consumer, this);
    }

    public static <A> Maybe<A> fromEither(Either<?, A> either) {
        return either.toMaybe();
    }

    public static <A> Maybe<A> fromOptional(Optional<? extends A> optional) {
        return optional.map(Maybe::just).orElse(Maybe.nothing());
    }

    public static <A> Maybe<A> maybe(A a) {
        return a == null ? Maybe.nothing() : Maybe.just(a);
    }

    public static <A> Maybe<A> just(A a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new Just(a);
    }

    public static <A> Maybe<A> nothing() {
        return Nothing.INSTANCE;
    }

    private static final class Nothing<A>
    extends Maybe<A> {
        private static final Nothing INSTANCE = new Nothing();

        private Nothing() {
        }

        @Override
        public <B> Maybe<B> flatMap(Function<? super A, ? extends Monad<B, Maybe>> f) {
            return Nothing.nothing();
        }

        @Override
        public <B, App extends Applicative, TravB extends Traversable<B, Maybe>, AppB extends Applicative<B, App>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Function<? super A, ? extends AppB> fn, Function<? super TravB, ? extends AppTrav> pure) {
            return (AppTrav)((Applicative)pure.apply(Nothing.nothing()));
        }

        @Override
        public A orElseGet(Supplier<A> otherSupplier) {
            return otherSupplier.get();
        }

        public String toString() {
            return "Nothing";
        }
    }

    private static final class Just<A>
    extends Maybe<A> {
        private final A a;

        private Just(A a) {
            this.a = a;
        }

        @Override
        public A orElseGet(Supplier<A> otherSupplier) {
            return this.a;
        }

        @Override
        public <B> Maybe<B> flatMap(Function<? super A, ? extends Monad<B, Maybe>> f) {
            return (Maybe)f.apply(this.a).coerce();
        }

        @Override
        public <B, App extends Applicative, TravB extends Traversable<B, Maybe>, AppB extends Applicative<B, App>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Function<? super A, ? extends AppB> fn, Function<? super TravB, ? extends AppTrav> pure) {
            return (AppTrav)((Applicative)fn.apply(this.a)).fmap(Just::new).fmap(Applicative::coerce).coerce();
        }

        public boolean equals(Object other) {
            return other instanceof Just && Objects.equals(this.a, ((Just)other).a);
        }

        public int hashCode() {
            return Objects.hash(this.a);
        }

        public String toString() {
            return "Just " + this.a;
        }
    }
}

