/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.adt;

import com.jnape.palatable.lambda.adt.Either;
import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.adt.Unit;
import com.jnape.palatable.lambda.adt.coproduct.CoProduct2;
import com.jnape.palatable.lambda.functions.builtin.fn1.Constantly;
import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functions.builtin.fn2.Peek2;
import com.jnape.palatable.lambda.functions.specialized.checked.CheckedRunnable;
import com.jnape.palatable.lambda.functions.specialized.checked.CheckedSupplier;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.BoundedBifunctor;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Objects;
import java.util.function.Function;

public abstract class Try<T extends Throwable, A>
implements Monad<A, Try<T, ?>>,
Traversable<A, Try<T, ?>>,
BoundedBifunctor<T, A, Throwable, Object, Try<?, ?>>,
CoProduct2<T, A, Try<T, A>> {
    private Try() {
    }

    public final <S extends T> Try<T, A> catching(Class<S> throwableType, Function<? super S, ? extends A> recoveryFn) {
        return this.catching(throwableType::isInstance, (? super T t) -> recoveryFn.apply((Object)t));
    }

    public final Try<T, A> catching(Function<? super T, Boolean> predicate, Function<? super T, ? extends A> recoveryFn) {
        return this.match(t -> (Boolean)predicate.apply(t) != false ? Try.success(recoveryFn.apply(t)) : Try.failure(t), Try::success);
    }

    public final Try<T, A> ensuring(CheckedRunnable<T> runnable) {
        return this.match(t -> ((Try)Peek2.peek2(t::addSuppressed, __ -> {}, Try.trying(runnable)).biMapL((Function)Constantly.constantly(t))).flatMap((Function)Constantly.constantly(Try.failure(t))), a -> Try.trying(runnable).fmap((Function)Constantly.constantly(a)));
    }

    public final A recover(Function<? super T, ? extends A> fn) {
        return this.match(fn, Id.id());
    }

    public final T forfeit(Function<? super A, ? extends T> fn) {
        return (T)((Throwable)this.match(Id.id(), fn));
    }

    public abstract A orThrow() throws T;

    public final Maybe<A> toMaybe() {
        return this.match(__ -> Maybe.nothing(), Maybe::just);
    }

    public final Either<T, A> toEither() {
        return this.toEither(Id.id());
    }

    public final <L> Either<L, A> toEither(Function<? super T, ? extends L> fn) {
        return this.match(fn.andThen(Either::left), Either::right);
    }

    @Override
    public <B> Try<T, B> fmap(Function<? super A, ? extends B> fn) {
        return (Try)Monad.super.fmap((Function)fn).coerce();
    }

    @Override
    public <B> Try<T, B> flatMap(Function<? super A, ? extends Monad<B, Try<T, ?>>> f) {
        return this.match(Try::failure, a -> (Try)((Monad)f.apply((Object)a)).coerce());
    }

    @Override
    public <B> Try<T, B> pure(B b) {
        return Try.success(b);
    }

    @Override
    public <B> Try<T, B> zip(Applicative<Function<? super A, ? extends B>, Try<T, ?>> appFn) {
        return (Try)Monad.super.zip(appFn).coerce();
    }

    @Override
    public <B> Try<T, B> discardL(Applicative<B, Try<T, ?>> appB) {
        return (Try)Monad.super.discardL(appB).coerce();
    }

    @Override
    public <B> Try<T, A> discardR(Applicative<B, Try<T, ?>> appB) {
        return (Try)Monad.super.discardR(appB).coerce();
    }

    @Override
    public <B, App extends Applicative, TravB extends Traversable<B, Try<T, ?>>, AppB extends Applicative<B, App>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Function<? super A, ? extends AppB> fn, Function<? super TravB, ? extends AppTrav> pure) {
        return (AppTrav)this.match(t -> (Applicative)pure.apply((Object)Try.failure(t)), a -> ((Applicative)fn.apply((Object)a)).fmap(Try::success).fmap(Applicative::coerce).coerce());
    }

    public <U extends Throwable, D> Try<U, D> biMap(Function<? super T, ? extends U> lFn, Function<? super A, ? extends D> rFn) {
        return this.match(t -> Try.failure((Throwable)lFn.apply(t)), a -> Try.success(rFn.apply((Object)a)));
    }

    public <U extends Throwable> Try<U, A> biMapL(Function<? super T, ? extends U> fn) {
        return (Try)BoundedBifunctor.super.biMapL(fn);
    }

    public <B> Try<T, B> biMapR(Function<? super A, ? extends B> fn) {
        return (Try)BoundedBifunctor.super.biMapR(fn);
    }

    public static <T extends Throwable, A> Try<T, A> success(A a) {
        return new Success(a);
    }

    public static <T extends Throwable, A> Try<T, A> failure(T t) {
        return new Failure(t, null);
    }

    public static <T extends Throwable, A> Try<T, A> trying(CheckedSupplier<T, A> supplier) {
        try {
            return Try.success(supplier.get());
        }
        catch (Throwable t) {
            return Try.failure(t);
        }
    }

    public static <T extends Throwable> Try<T, Unit> trying(CheckedRunnable<T> runnable) {
        return Try.trying(() -> {
            runnable.run();
            return Unit.UNIT;
        });
    }

    private static final class Success<T extends Throwable, A>
    extends Try<T, A> {
        private final A a;

        private Success(A a) {
            this.a = a;
        }

        @Override
        public A orThrow() throws T {
            return this.a;
        }

        @Override
        public <R> R match(Function<? super T, ? extends R> aFn, Function<? super A, ? extends R> bFn) {
            return bFn.apply(this.a);
        }

        public boolean equals(Object other) {
            return other instanceof Success && Objects.equals(this.a, ((Success)other).a);
        }

        public int hashCode() {
            return Objects.hash(this.a);
        }

        public String toString() {
            return "Success{a=" + this.a + '}';
        }
    }

    private static final class Failure<T extends Throwable, A>
    extends Try<T, A> {
        private final T t;

        private Failure(T t) {
            this.t = t;
        }

        @Override
        public A orThrow() throws T {
            throw this.t;
        }

        @Override
        public <R> R match(Function<? super T, ? extends R> aFn, Function<? super A, ? extends R> bFn) {
            return aFn.apply(this.t);
        }

        public boolean equals(Object other) {
            return other instanceof Failure && Objects.equals(this.t, ((Failure)other).t);
        }

        public int hashCode() {
            return Objects.hash(this.t);
        }

        public String toString() {
            return "Failure{t=" + this.t + '}';
        }

        /* synthetic */ Failure(Throwable x0, 1 x1) {
            this(x0);
        }
    }
}

