/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.adt.hlist;

import com.jnape.palatable.lambda.adt.hlist.SingletonHList;
import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.adt.hlist.Tuple3;
import com.jnape.palatable.lambda.adt.hlist.Tuple4;
import com.jnape.palatable.lambda.adt.hlist.Tuple5;
import com.jnape.palatable.lambda.adt.hlist.Tuple6;
import com.jnape.palatable.lambda.adt.hlist.Tuple7;
import com.jnape.palatable.lambda.adt.hlist.Tuple8;
import java.util.Objects;

public abstract class HList {
    private HList() {
    }

    public abstract <NewHead> HCons<NewHead, ? extends HList> cons(NewHead var1);

    public final String toString() {
        StringBuilder body = new StringBuilder("HList{");
        HList next = this;
        while (next != HNil.INSTANCE) {
            HCons hCons = (HCons)next;
            body.append(" ").append(hCons.head).append(" ");
            next = hCons.tail;
            if (next == HNil.INSTANCE) continue;
            body.append("::");
        }
        return body.append("}").toString();
    }

    public static HNil nil() {
        return HNil.INSTANCE;
    }

    public static <Head, Tail extends HList> HCons<Head, Tail> cons(Head head, Tail tail) {
        return new HCons<Head, Tail>(head, tail);
    }

    public static <Head> SingletonHList<Head> singletonHList(Head head) {
        return new SingletonHList<Head>(head);
    }

    public static <_1, _2> Tuple2<_1, _2> tuple(_1 _1, _2 _2) {
        return HList.singletonHList(_2).cons(_1);
    }

    public static <_1, _2, _3> Tuple3<_1, _2, _3> tuple(_1 _1, _2 _2, _3 _3) {
        return HList.tuple(_2, _3).cons(_1);
    }

    public static <_1, _2, _3, _4> Tuple4<_1, _2, _3, _4> tuple(_1 _1, _2 _2, _3 _3, _4 _4) {
        return HList.tuple(_2, _3, _4).cons(_1);
    }

    public static <_1, _2, _3, _4, _5> Tuple5<_1, _2, _3, _4, _5> tuple(_1 _1, _2 _2, _3 _3, _4 _4, _5 _5) {
        return HList.tuple(_2, _3, _4, _5).cons(_1);
    }

    public static <_1, _2, _3, _4, _5, _6> Tuple6<_1, _2, _3, _4, _5, _6> tuple(_1 _1, _2 _2, _3 _3, _4 _4, _5 _5, _6 _6) {
        return HList.tuple(_2, _3, _4, _5, _6).cons(_1);
    }

    public static <_1, _2, _3, _4, _5, _6, _7> Tuple7<_1, _2, _3, _4, _5, _6, _7> tuple(_1 _1, _2 _2, _3 _3, _4 _4, _5 _5, _6 _6, _7 _7) {
        return HList.tuple(_2, _3, _4, _5, _6, _7).cons(_1);
    }

    public static <_1, _2, _3, _4, _5, _6, _7, _8> Tuple8<_1, _2, _3, _4, _5, _6, _7, _8> tuple(_1 _1, _2 _2, _3 _3, _4 _4, _5 _5, _6 _6, _7 _7, _8 _8) {
        return HList.tuple(_2, _3, _4, _5, _6, _7, _8).cons(_1);
    }

    public static final class HNil
    extends HList {
        private static final HNil INSTANCE = new HNil();

        private HNil() {
        }

        public <Head> SingletonHList<Head> cons(Head head) {
            return new SingletonHList<Head>(head);
        }
    }

    public static class HCons<Head, Tail extends HList>
    extends HList {
        private final Head head;
        private final Tail tail;

        HCons(Head head, Tail tail) {
            this.head = head;
            this.tail = tail;
        }

        public Head head() {
            return this.head;
        }

        public Tail tail() {
            return this.tail;
        }

        public <NewHead> HCons<NewHead, ? extends HCons<Head, Tail>> cons(NewHead newHead) {
            return new HCons<NewHead, HCons>(newHead, this);
        }

        public final boolean equals(Object other) {
            if (other instanceof HCons) {
                HCons that = (HCons)other;
                return this.head.equals(that.head) && this.tail.equals(that.tail);
            }
            return false;
        }

        public final int hashCode() {
            return 31 * Objects.hashCode(this.head) + this.tail.hashCode();
        }
    }
}

