/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.functions.builtin.fn2;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.Fn2;
import com.jnape.palatable.lambda.functions.builtin.fn2.ToCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class SortBy<A, B extends Comparable<B>>
implements Fn2<Function<? super A, ? extends B>, Iterable<A>, List<A>> {
    private static final SortBy INSTANCE = new SortBy();

    private SortBy() {
    }

    @Override
    public List<A> apply(Function<? super A, ? extends B> fn, Iterable<A> as) {
        List result = ToCollection.toCollection(ArrayList::new, as);
        result.sort(Comparator.comparing(fn));
        return result;
    }

    public static <A, B extends Comparable<B>> SortBy<A, B> sortBy() {
        return INSTANCE;
    }

    public static <A, B extends Comparable<B>> Fn1<Iterable<A>, List<A>> sortBy(Function<? super A, ? extends B> fn) {
        return SortBy.sortBy().apply(fn);
    }

    public static <A, B extends Comparable<B>> List<A> sortBy(Function<? super A, ? extends B> fn, Iterable<A> as) {
        return SortBy.sortBy(fn).apply(as);
    }
}

