/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.functions.specialized.checked;

import com.jnape.palatable.lambda.adt.Unit;
import com.jnape.palatable.lambda.functions.specialized.checked.CheckedSupplier;
import com.jnape.palatable.lambda.functions.specialized.checked.Runtime;

@FunctionalInterface
public interface CheckedRunnable<T extends Throwable>
extends Runnable {
    @Override
    default public void run() {
        try {
            this.checkedRun();
        }
        catch (Throwable t) {
            throw Runtime.throwChecked(t);
        }
    }

    public void checkedRun() throws T;

    default public CheckedSupplier<T, Unit> toSupplier() {
        return () -> {
            this.run();
            return Unit.UNIT;
        };
    }

    public static <T extends Throwable> CheckedRunnable<T> checked(CheckedRunnable<T> runnable) {
        return runnable::run;
    }
}

