/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.functions.specialized.checked;

import com.jnape.palatable.lambda.functions.specialized.checked.CheckedRunnable;
import com.jnape.palatable.lambda.functions.specialized.checked.Runtime;
import java.util.function.Supplier;

@FunctionalInterface
public interface CheckedSupplier<T extends Throwable, A>
extends Supplier<A> {
    @Override
    default public A get() {
        try {
            return this.checkedGet();
        }
        catch (Throwable t) {
            throw Runtime.throwChecked(t);
        }
    }

    public A checkedGet() throws T;

    default public CheckedRunnable<T> toRunnable() {
        return this::get;
    }

    public static <T extends Throwable, A> CheckedSupplier<T, A> checked(CheckedSupplier<T, A> supplier) {
        return supplier::get;
    }
}

