/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.adt.hlist.HList;
import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.iteration.ImmutableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class CombinatorialIterator<A, B>
extends ImmutableIterator<Tuple2<A, B>> {
    private final Iterator<A> asIterator;
    private final Iterator<B> bsIterator;
    private final ListIterator<B> doublyLinkedBsIterator;
    private A currentA;

    public CombinatorialIterator(Iterator<A> asIterator, Iterator<B> bsIterator) {
        this.asIterator = asIterator;
        this.bsIterator = bsIterator;
        this.doublyLinkedBsIterator = new ArrayList().listIterator();
        this.currentA = null;
    }

    @Override
    public boolean hasNext() {
        return (this.moreAs() || this.currentA != null) && this.moreBs();
    }

    @Override
    public Tuple2<A, B> next() {
        if (this.currentA == null) {
            this.currentA = this.asIterator.next();
        }
        if (this.bsIterator.hasNext()) {
            this.doublyLinkedBsIterator.add(this.bsIterator.next());
            this.doublyLinkedBsIterator.previous();
        }
        Tuple2<A, B> tuple = HList.tuple(this.currentA, this.doublyLinkedBsIterator.next());
        if (this.moreAs() && !this.moreBs()) {
            this.currentA = this.asIterator.next();
            while (this.doublyLinkedBsIterator.hasPrevious()) {
                this.doublyLinkedBsIterator.previous();
            }
        }
        return tuple;
    }

    private boolean moreAs() {
        return this.asIterator.hasNext();
    }

    private boolean moreBs() {
        return this.bsIterator.hasNext() || this.doublyLinkedBsIterator.hasNext();
    }
}

