/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.iteration.InfiniteIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class CyclicIterator<A>
extends InfiniteIterator<A> {
    private final Iterator<A> iterator;
    private final ListIterator<A> doublyLinkedIterator;

    public CyclicIterator(Iterator<A> iterator) {
        this.iterator = iterator;
        this.doublyLinkedIterator = new ArrayList().listIterator();
    }

    @Override
    public A next() {
        return this.iterator.hasNext() ? this.continueInitialIteration() : this.continueCachedIteration();
    }

    private A continueCachedIteration() {
        if (!this.doublyLinkedIterator.hasNext()) {
            while (this.doublyLinkedIterator.hasPrevious()) {
                this.doublyLinkedIterator.previous();
            }
        }
        return this.doublyLinkedIterator.next();
    }

    private A continueInitialIteration() {
        A next = this.iterator.next();
        this.doublyLinkedIterator.add(next);
        return next;
    }
}

