/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.iteration.ImmutableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DroppingIterator<A>
extends ImmutableIterator<A> {
    private final Integer n;
    private final Iterator<A> asIterator;
    private boolean dropped;

    public DroppingIterator(Integer n, Iterator<A> asIterator) {
        this.n = n;
        this.asIterator = asIterator;
        this.dropped = false;
    }

    @Override
    public boolean hasNext() {
        if (!this.dropped) {
            this.drop();
        }
        return this.asIterator.hasNext();
    }

    @Override
    public A next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.asIterator.next();
    }

    private void drop() {
        int i = 0;
        while (i++ < this.n && this.asIterator.hasNext()) {
            this.asIterator.next();
        }
        this.dropped = true;
    }
}

