/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.functions.builtin.fn2.All;
import com.jnape.palatable.lambda.iteration.FilteringIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public final class FilteringIterable<A>
implements Iterable<A> {
    private final List<Function<? super A, Boolean>> predicates;
    private final Iterable<A> as;

    public FilteringIterable(Function<? super A, Boolean> predicate, Iterable<A> as) {
        ArrayList<Function<A, Boolean>> predicates = new ArrayList<Function<A, Boolean>>(Collections.singletonList(predicate));
        while (as instanceof FilteringIterable) {
            FilteringIterable nested = (FilteringIterable)as;
            predicates.addAll(nested.predicates);
            as = nested.as;
        }
        this.predicates = predicates;
        this.as = as;
    }

    @Override
    public Iterator<A> iterator() {
        Function<Object, Boolean> metaPredicate = a -> All.all(p -> (Boolean)p.apply(a), this.predicates);
        return new FilteringIterator<Object>(metaPredicate, this.as.iterator());
    }
}

