/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.iteration.ImmutableIterator;
import com.jnape.palatable.lambda.iteration.RewindableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class FilteringIterator<A>
extends ImmutableIterator<A> {
    private final Function<? super A, Boolean> predicate;
    private final RewindableIterator<A> rewindableIterator;

    public FilteringIterator(Function<? super A, Boolean> predicate, Iterator<A> iterator) {
        this.predicate = predicate;
        this.rewindableIterator = new RewindableIterator<A>(iterator);
    }

    @Override
    public boolean hasNext() {
        return this.rewindableIterator.isRewound() || this.hasMoreMatchingElements();
    }

    @Override
    public A next() {
        if (this.hasNext()) {
            return this.rewindableIterator.next();
        }
        throw new NoSuchElementException();
    }

    private boolean hasMoreMatchingElements() {
        while (this.rewindableIterator.hasNext()) {
            if (!this.predicate.apply(this.rewindableIterator.next()).booleanValue()) continue;
            this.rewindableIterator.rewind();
            return true;
        }
        return false;
    }
}

