/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.functions.builtin.fn1.Constantly;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.lambda.iteration.ImmutableStack;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

abstract class ImmutableQueue<A>
implements Iterable<A> {
    ImmutableQueue() {
    }

    abstract ImmutableQueue<A> pushFront(A var1);

    abstract ImmutableQueue<A> pushBack(A var1);

    abstract Maybe<A> head();

    abstract ImmutableQueue<A> tail();

    abstract ImmutableQueue<A> concat(ImmutableQueue<A> var1);

    final boolean isEmpty() {
        return ((Maybe)this.head().fmap((Function)Constantly.constantly(false))).orElse(true);
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            private ImmutableQueue<A> queue;
            {
                this.queue = ImmutableQueue.this;
            }

            @Override
            public boolean hasNext() {
                return !this.queue.isEmpty();
            }

            @Override
            public A next() {
                Object next = this.queue.head().orElseThrow(NoSuchElementException::new);
                this.queue = this.queue.tail();
                return next;
            }
        };
    }

    public static <A> ImmutableQueue<A> empty() {
        return Empty.INSTANCE;
    }

    private static final class NonEmpty<A>
    extends ImmutableQueue<A> {
        private final ImmutableStack<A> outbound;
        private final ImmutableStack<A> inbound;

        private NonEmpty(ImmutableStack<A> outbound, ImmutableStack<A> inbound) {
            this.outbound = outbound;
            this.inbound = inbound;
        }

        @Override
        ImmutableQueue<A> pushFront(A a) {
            return new NonEmpty<A>(this.outbound.push(a), this.inbound);
        }

        @Override
        ImmutableQueue<A> pushBack(A a) {
            return new NonEmpty<A>(this.outbound, this.inbound.push(a));
        }

        @Override
        ImmutableQueue<A> concat(ImmutableQueue<A> other) {
            return new NonEmpty<A>(this.outbound, FoldLeft.foldLeft(ImmutableStack::push, this.inbound, other));
        }

        @Override
        Maybe<A> head() {
            return this.outbound.head();
        }

        @Override
        ImmutableQueue<A> tail() {
            ImmutableStack<A> outTail = this.outbound.tail();
            if (!outTail.isEmpty()) {
                return new NonEmpty<A>(outTail, this.inbound);
            }
            ImmutableStack newOutbound = FoldLeft.foldLeft(ImmutableStack::push, ImmutableStack.empty(), this.inbound);
            return newOutbound.isEmpty() ? NonEmpty.empty() : new NonEmpty(newOutbound, ImmutableStack.empty());
        }
    }

    private static final class Empty<A>
    extends ImmutableQueue<A> {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        ImmutableQueue<A> pushFront(A a) {
            return new NonEmpty(ImmutableStack.empty().push(a), ImmutableStack.empty());
        }

        @Override
        ImmutableQueue<A> pushBack(A a) {
            return this.pushFront(a);
        }

        @Override
        ImmutableQueue<A> concat(ImmutableQueue<A> other) {
            return other;
        }

        @Override
        Maybe<A> head() {
            return Maybe.nothing();
        }

        @Override
        ImmutableQueue<A> tail() {
            return this;
        }
    }
}

